<?php
session_start();
include '../includes/conn.php'; // Database connection file

header('Content-Type: application/json');

// Check if database connection exists
if (!$connection) {
    die(json_encode(["status" => "error", "message" => "Database connection error"]));
}

// Ensure the session grade is set
if (!isset($_SESSION['sgrade'])) {
    echo json_encode(["status" => "error", "message" => "User grade not found"]);
    exit();
}

$sgrade = $_SESSION['sgrade']; // Get user's grade from session

// Fetch main titles (filtered by grade)
$sql = "SELECT tId, tName, tGrade FROM maintittletbl WHERE tGrade = ? ORDER BY tId ASC";
$stmt = $connection->prepare($sql);
$stmt->bind_param("i", $sgrade); // Bind grade parameter
$stmt->execute();
$result = $stmt->get_result();

if (!$result) {
    die(json_encode(["status" => "error", "message" => "Main title query failed: " . $connection->error]));
}

$data = [];
while ($row = $result->fetch_assoc()) {
    $tId = $row['tId'];

    // Fetch related subtitles (videos) for this tId
    $subSql = "SELECT * FROM subtittleonetbl WHERE tId = ? ORDER BY stoneId ASC";
    $subStmt = $connection->prepare($subSql);
    $subStmt->bind_param("i", $tId); // Bind integer parameter
    $subStmt->execute();
    $subResult = $subStmt->get_result();

    $subtitles = [];
    while ($subRow = $subResult->fetch_assoc()) {
        $subtitles[] = [
            "stoneId" => $subRow['stoneId'],
            "stName" => $subRow['stName'] // Assuming video URL is stored in the database
        ];
    }

    $row['subtitles'] = $subtitles; // Attach subtitles to the title
    $data[] = $row;
}

echo json_encode(["status" => "success", "data" => $data]);

// Close connection
$connection->close();
?>
