<?php
include '../includes/conn.php';
header('Content-Type: application/json');

// Check if the search term is set in the GET request
if (isset($_GET['term'])) {
    $searchTerm = "%" . $_GET['term'] . "%"; // Wildcards for LIKE search

    // Query to get students based on either Sid or Sfname
    $query = "SELECT * FROM studenttbl WHERE Sid LIKE ? OR Sfname LIKE ? LIMIT 10";
    $stmt = mysqli_prepare($connection, $query);

    if ($stmt) {
        // Bind the parameters: searchTerm (string) for both Sid and Sfname
        mysqli_stmt_bind_param($stmt, "ss", $searchTerm, $searchTerm);
        mysqli_stmt_execute($stmt);
        $result = mysqli_stmt_get_result($stmt);

        $data = [];
        while ($row = mysqli_fetch_assoc($result)) {
            $data[] = [
                "label" => $row['Sfname'], // Displayed in autocomplete dropdown
                "value" => $row['Sfname'], // What gets inserted in input field
                "id"    => $row['Sid'],  // Extra data if needed (e.g., student ID)
                "slname"    => $row['Slname'],  // Extra data if needed (e.g., student ID)
                "sgrade"    => $row['Sgrade']  // Extra data if needed (e.g., student ID)
            ];
        }

        echo json_encode($data);  // Return the data as JSON
    } else {
        echo json_encode(["error" => "Database query failed"]);
    }
} else {
    // If 'term' is not provided, return an error
    echo json_encode(["error" => "Invalid input"]);
}
?>
