<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
include '../includes/conn.php';
header('Content-Type: application/json');

// Check if the search term is set in the GET request
if (isset($_GET['term'])) {
    $searchTerm = "%" . $_GET['term'] . "%"; // Wildcards for LIKE search

    // Query to get video details
    $query = "SELECT * FROM subtittletwotbl WHERE sttwoName LIKE ? LIMIT 10";
    $stmt = mysqli_prepare($connection, $query);

    if ($stmt) {
        mysqli_stmt_bind_param($stmt, "s", $searchTerm);
        mysqli_stmt_execute($stmt);
        $result = mysqli_stmt_get_result($stmt);

        $data = [];
        while ($row = mysqli_fetch_assoc($result)) {
            $data[] = [
                "label"  => $row['sttwoName'], // Displayed in autocomplete dropdown
                "value"  => $row['sttwoName'], // What gets inserted in input field
                "id"     => $row['sttwoId'],   // Video ID
                "videograde" => $row['videograde'], // Grade from database
                "maintitle" => $row['maintitle'],
                "subtitle" => $row['subtitle']
            ];
        }

        echo json_encode($data);
    } else {
        echo json_encode(["error" => "Database query failed"]);
    }
} else {
    echo json_encode(["error" => "Invalid input"]);
}
?>
