<?php 
include '../includes/conn.php'; 
session_start();

if (isset($_POST['addnewstudentbtn'])) {
    // Escape user inputs for security
    $studentadddate = mysqli_real_escape_string($connection, $_POST['currdate']);
    $studentfname = mysqli_real_escape_string($connection, $_POST['inputSfname']);
    $studentlname = mysqli_real_escape_string($connection, $_POST['inputSlname']);
    $studentadd1 = mysqli_real_escape_string($connection, $_POST['inputAdd1']);
    $studentadd2 = mysqli_real_escape_string($connection, $_POST['inputAdd2']);
    $studentcity = mysqli_real_escape_string($connection, $_POST['inputScity']);
    $studentbd = mysqli_real_escape_string($connection, $_POST['inputSbd']);
    $studentage = mysqli_real_escape_string($connection, $_POST['inputSage']);
    $studentgender = mysqli_real_escape_string($connection, $_POST['inputSgender']);
    $studentgrade = mysqli_real_escape_string($connection, $_POST['inputSgrade']);
    $studentschl = mysqli_real_escape_string($connection, $_POST['inputSschool']);
    $studentcontact = mysqli_real_escape_string($connection, $_POST['inputScontact']);
    $studentwa = mysqli_real_escape_string($connection, $_POST['inputWAno']);
    $studentgname = mysqli_real_escape_string($connection, $_POST['inputGname']);
    $studentgcontact = mysqli_real_escape_string($connection, $_POST['inputGcontact']);
    $studentusername = mysqli_real_escape_string($connection, $_POST['logginuserName']);
    $studentpassword = $_POST['loginuserPassword']; // Do not escape passwords
    $studentprofile = $_FILES['inputuserSprofilepic']['name']; // File upload
    $studentstatus = "0";
    $jrole = "student";

    // Ensure connection is established
    if (!$connection) {
        die('Database connection failed: ' . mysqli_connect_error());
    }

    // ✅ Securely hash the password before storing
    $hashedPassword = password_hash($studentpassword, PASSWORD_DEFAULT);

    // Check if a file was uploaded without errors
    if (isset($_FILES['inputuserSprofilepic']) && $_FILES['inputuserSprofilepic']['error'] == 0) {
        $target_dir = "../images/profile/"; // Directory to save profile pictures
        $target_file = $target_dir . basename($_FILES['inputuserSprofilepic']['name']);

        // Ensure the file does not already exist
        if (!file_exists($target_file)) {
            // Move the uploaded file to the destination directory
            move_uploaded_file($_FILES['inputuserSprofilepic']['tmp_name'], $target_file);

            // SQL query using placeholders
            $query = "INSERT INTO studenttbl (
                Sfname, Slname, Sadd1, Sadd2, Sadd3, Sbd, Sage, Sgender, Sgrade, 
                Sschool, SContact, ScontactWA, Sgname, Sgcontact, Semail, 
                Spassword, Simage, jRole, Sadddate, Sstatus, Slastlogin) 
                VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, NOW())";

            // Prepare the statement
            $stmt = $connection->prepare($query);
            if (!$stmt) {
                die('Error preparing query: ' . $connection->error);
            }

            // Bind parameters
            $stmt->bind_param(
                "ssssssssssssssssssss",
                $studentfname, $studentlname, $studentadd1, $studentadd2, $studentcity, 
                $studentbd, $studentage, $studentgender, $studentgrade, $studentschl, 
                $studentcontact, $studentwa, $studentgname, $studentgcontact, 
                $studentusername, $hashedPassword, $studentprofile, $jrole, $studentadddate, $studentstatus
            );

            // Execute the query
            if ($stmt->execute()) {
                $_SESSION['success_message'] = "Your application has been uploaded successfully. You can log in after your application is approved. Approval details will be sent to your email.";
            } else {
                $_SESSION['error_message'] = "Error executing query: " . $stmt->error;
            }

            // Close the statement
            $stmt->close();
        } else {
            $_SESSION['error_message'] = "File already exists. Please choose a different file.";
        }
    } else {
        $_SESSION['error_message'] = "Error uploading file.";
    }

    // Redirect back to the login page
    header('Location: ../login.php');
} else {
    // Redirect if accessed without form submission
    header('Location: ../error.php');
}
?>
