<?php
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    include '../includes/conn.php'; // Include your database connection file

    $Sid = $_POST['Sid'];
    $Sstatus = $_POST['Sstatus'];

    // Update the student's status in the database
    $stmt = $connection->prepare("UPDATE studenttbl SET Sstatus = ? WHERE Sid = ?");
    $stmt->bind_param("ii", $Sstatus, $Sid);
    $stmt->execute();

    if ($stmt->affected_rows > 0) {
        // Fetch the student's email
        $stmt = $connection->prepare("SELECT Semail, Sfname FROM studenttbl WHERE Sid = ?");
        $stmt->bind_param("i", $Sid);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result->num_rows > 0) {
            $student = $result->fetch_assoc();
            $email = $student['Semail'];
            $name = $student['Sfname'];

            // Determine the email message based on Sstatus
            if ($Sstatus == 1) {
                $subject = "Your Application is Approved";
                $message = "Dear $name,\n\nYour application has been approved. You can now log in to the AV English Academy platform using your username and password.\n\nBest regards,\nAV English Academy";
                $headers = "From: noreply@avenglishacademy.com";

                if (mail($email, $subject, $message, $headers)) {
                    echo json_encode(["success" => true, "message" => "Status updated and approval email sent."]);
                } else {
                    echo json_encode(["success" => false, "message" => "Status updated, but approval email sending failed."]);
                }
            } elseif ($Sstatus == 2) {
                $subject = "Your Application is Removed";
                $message = "Dear $name,\n\nWe regret to inform you that your application has been removed. For further details, please contact us at support@avenglishacademy.com.\n\nBest regards,\nAV English Academy";
                $headers = "From: noreply@avenglishacademy.com";

                if (mail($email, $subject, $message, $headers)) {
                    echo json_encode(["success" => true, "message" => "Status updated and removal email sent."]);
                } else {
                    echo json_encode(["success" => false, "message" => "Status updated, but removal email sending failed."]);
                }
            } else {
                echo json_encode(["success" => true, "message" => "Status updated."]);
            }
        } else {
            echo json_encode(["success" => false, "message" => "Student not found."]);
        }
    } else {
        echo json_encode(["success" => false, "message" => "Failed to update status."]);
    }
}
?>
