<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Transparent Login</title>

  <!-- Bootstrap CSS -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">

  <style>
    body {
        background-image: url('img/english-pictures-62thzly2s31pvnda.jpg'); /* Update with the correct image path */
        background-size: cover;
        background-repeat: no-repeat;
        background-position: center;
        height: 100vh;
        margin: 0;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .card {
      max-width: 400px;
      height: auto;
      margin: auto;
      margin-top: 10vh;
      background-color: rgba(255, 255, 255, 0.8); /* Semi-transparent white */
      box-shadow: 0 4px 6px rgba(0, 0, 0, 0.2); /* Soft shadow */
    }

    .card-header, .card-footer {
      background-color: rgba(255, 255, 255, 0.6); /* Slightly more transparent */
      border-bottom: none;
    }

    .form-container {
      position: absolute;
      width: 100%;
      transition: transform 0.6s ease-in-out, opacity 0.6s ease-in-out;
    }

    .form-container.login {
      transform: translateX(0);
      opacity: 1;
      z-index: 2;
    }

    .form-container.signup {
      transform: translateX(100%);
      opacity: 0;
      z-index: 1;
    }

    /* Adjusting input size and making it smaller */
    .form-floating .form-control {
      background-color: rgba(255, 255, 255, 0.7); /* Transparent input fields */
      border: 1px solid rgba(0, 0, 0, 0.1);
      height: 35px; /* Custom height for smaller input */
      padding: 0.375rem 0.75rem; /* Custom padding for smaller input */
      font-size: 0.875rem; /* Smaller font size */
    }

    /* When the input is focused */
    .form-floating .form-control:focus {
      background-color: rgba(255, 255, 255, 0.9); /* Slightly less transparent when focused */
      border-color: rgba(106, 17, 203, 0.5);
      box-shadow: 0 0 5px rgba(106, 17, 203, 0.5);
    }

    /* Custom styles for button */
    .btn-primary {
      font-size: 0.875rem;
      padding: 0.5rem 1rem;
    }
  </style>
</head>
<body>
<div class="container">
    <div class="row">
        <div class="col-lg-12">
            <div class="card text-center border-info">
                <!-- Card Header -->
                <div class="card-header">
                    <h5 id="formTitle">Login</h5>
                </div>

                <!-- Card Body -->
                <div class="card-body">
                    <!-- Login Form -->
                    <form id="loginForm" class="form-container">
                        <div class="form-floating mb-3">
                            <input type="email" class="form-control" id="loginEmail" placeholder="name@example.com">
                            <label for="loginEmail">Email address</label>
                        </div>
                        <div class="form-floating mb-3">
                            <input type="password" class="form-control" id="loginPassword" placeholder="Password">
                            <label for="loginPassword">Password</label>
                        </div>
                        <button type="button" class="btn btn-primary mt-3">Login</button>
                    </form>

                    <!-- Signup Form -->
                    <form id="signupForm" class="form-container d-none">
                        <div class="form-floating mb-3">
                            <input type="text" class="form-control" id="signupUsername" placeholder="Username">
                            <label for="signupUsername">Username</label>
                        </div>
                        <div class="form-floating mb-3">
                            <input type="email" class="form-control" id="signupEmail" placeholder="name@example.com">
                            <label for="signupEmail">Email address</label>
                        </div>
                        <div class="form-floating mb-3">
                            <input type="password" class="form-control" id="signupPassword" placeholder="Password">
                            <label for="signupPassword">Password</label>
                        </div>
                        <button type="button" class="btn btn-primary mt-3">Signup</button>
                    </form>
                </div>

                <!-- Card Footer -->
                <div class="card-footer">
          



<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

<!-- JavaScript -->
<script>
  document.addEventListener("DOMContentLoaded", () => {
    const toggleFormBtn = document.getElementById("toggleForm");
    const loginForm = document.querySelector(".form-container.login");
    const signupForm = document.querySelector(".form-container.signup");

    toggleFormBtn.addEventListener("click", () => {
      if (loginForm.classList.contains("login")) {
        loginForm.classList.remove("login");
        signupForm.classList.remove("signup");
        loginForm.classList.add("signup");
        signupForm.classList.add("login");
        toggleFormBtn.textContent = "Switch to Login";
      } else {
        loginForm.classList.remove("signup");
        signupForm.classList.remove("login");
        loginForm.classList.add("login");
        signupForm.classList.add("signup");
        toggleFormBtn.textContent = "Switch to Signup";
      }
    });
  });
</script>

</body>
</html>
