<?php
include '../includes/conn.php';
header('Content-Type: application/json');

// Check if the search term and titleId are set in the GET request
if (isset($_GET['term']) && isset($_GET['titleId'])) {
    $searchTerm = "%{$_GET['term']}%"; // Wildcards for LIKE search
    $titleId = mysqli_real_escape_string($connection, $_GET['titleId']);  // Escape the titleId for security

    // Query to get subtitles filtered by the selected titleId
    $query = "SELECT stoneId, stName FROM subtittleonetbl WHERE tId = ? AND stName LIKE ? LIMIT 10";
    $stmt = mysqli_prepare($connection, $query);

    if ($stmt) {
        // Bind the parameters: titleId (integer) and searchTerm (string)
        mysqli_stmt_bind_param($stmt, "is", $titleId, $searchTerm);
        mysqli_stmt_execute($stmt);
        $result = mysqli_stmt_get_result($stmt);

        $data = [];
        while ($row = mysqli_fetch_assoc($result)) {
            $data[] = [
                "label" => $row['stName'], // Displayed in autocomplete dropdown
                "value" => $row['stName'], // What gets inserted in input field
                "id"    => $row['stoneId']  // Extra data if needed (e.g., ID of subtitle)
            ];
        }

        echo json_encode($data);  // Return the data as JSON
    } else {
        echo json_encode(["error" => "Database query failed"]);
    }
} else {
    // If 'term' or 'titleId' are not provided, return an error
    echo json_encode(["error" => "Invalid input"]);
}
?>

