<?php
include '../includes/conn.php';
header('Content-Type: application/json');

if (isset($_GET['term'])) {
    $searchTerm = "%{$_GET['term']}%"; // Wildcards for LIKE search

    $query = "SELECT tId, tName FROM maintittletbl WHERE tName LIKE ? LIMIT 10";
    $stmt = mysqli_prepare($connection, $query);

    if ($stmt) {
        mysqli_stmt_bind_param($stmt, "s", $searchTerm);
        mysqli_stmt_execute($stmt);
        $result = mysqli_stmt_get_result($stmt);

        $data = [];
        while ($row = mysqli_fetch_assoc($result)) {
            $data[] = [
                "label" => $row['tName'], // Displayed in autocomplete dropdown
                "value" => $row['tName'], // What gets inserted in input field
                "id"    => $row['tId']  // Extra data if needed
            ];
        }

        echo json_encode($data);
    } else {
        echo json_encode(["error" => "Database query failed"]);
    }
}
?>

