<?php
session_start(); // Start the session
include '../includes/conn.php'; // Include database connection

header('Content-Type: application/json'); // Set response type to JSON

// Check if the user is logged in
if (!isset($_SESSION['studentid'])) {
    echo json_encode(["success" => false, "message" => "User not logged in."]);
    exit;
}

$Sid = intval($_SESSION['studentid']); // Get the logged-in user's ID

// Prepare the SQL query
$stmt = $connection->prepare("SELECT * FROM studenttbl WHERE Sid = ?");
if (!$stmt) {
    echo json_encode(["success" => false, "message" => "Database query failed.", "error" => mysqli_error($connection)]);
    exit;
}

$stmt->bind_param("i", $Sid);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    $student = $result->fetch_assoc();

    // Build the full image path
    $imageFolder = 'http://localhost/PlusCoding_avenglish2/admin/images/profile/';
    $imageName = $student['Simage'];

    // Use the correct server path for file_exists()
    $localImagePath = $_SERVER['DOCUMENT_ROOT'] . "/PlusCoding_avenglish2/admin/images/profile/" . $imageName;

    if (file_exists($localImagePath) && !empty($imageName)) {
        $student['imageUrl'] = $imageFolder . $imageName;
    } else {
        $student['imageUrl'] = $imageFolder . 'default-image.jpg';
    }

    // Return student data
    echo json_encode(["success" => true, "data" => $student], JSON_UNESCAPED_UNICODE);
} else {
    echo json_encode(["success" => false, "message" => "Student not found."]);
}

$stmt->close();
$connection->close();
?>
