
    <?php include 'includes/head.php' ?>
    <?php include 'includes/topnav.php' ?>
    <style>
            .body {
                background: url('images/background/back3.jpg') no-repeat center center/cover;
                position: relative;
                padding: 20px;
            }

            /* Overlay to create blur effect */
            .body::before {
                content: "";
                position: absolute;
                top: 0;
                left: 0;
                width: 100%;
                height: 100%;
                background: inherit;
                filter: blur(2px); /* Adjust blur intensity */
                z-index: -1;
            }
            .sdetails{
                font-weight: bold;
            }
            .data{
                color: #28a745;
                text-transform: uppercase;
            }
            /* Ensure all table content is centered */
            #purchasedVideosTbl {
                text-align: center !important;
            }

            #purchasedVideosTbl th, 
            #purchasedVideosTbl td {
                text-align: center !important;
                vertical-align: middle !important;
            }
            .card {
                background: rgba(255, 255, 255, 0.2); /* Semi-transparent white */
                backdrop-filter: blur(10px); /* Apply blur effect */
                border-radius: 12px; /* Rounded corners */
                padding: 15px;
                box-shadow: 0px 4px 10px rgba(0, 0, 0, 0.2); /* Soft shadow */
                transition: all 0.3s ease-in-out;
            }

            /* Optional: Hover Effect for better interaction */
            .card:hover {
                backdrop-filter: blur(15px);
                box-shadow: 0px 6px 15px rgba(0, 0, 0, 0.3);
            }
        </style>

    <body class="body sb-nav-fixed">
        
        
        <?php 
            // Check if user is logged in
            if (!isset($_SESSION['studentid'])) {
                header("Location: login.php"); // Redirect to login page
                exit();
            }
        ?>

        <div id="layoutSidenav">
            <?php include 'includes/sidenav.php' ?>

            <div id="layoutSidenav_content">
                <main>
                    <div class="container-fluid px-4">
                        <h1 class="mt-4">Dashboard</h1>
                        <ol class="breadcrumb mb-4">
                            <li class="breadcrumb-item active">Dashboard</li>
                        </ol>
                        <div class="row  d-flex justify-content-center">
                            <div class="col-lg-6 col-md-6">
                                <div class="card border-warning mb-4">
                                    <div class="card-body sdetails d-flex">
                                        <!-- User Image -->
                                        <div class="text-center me-3">
                                            <img id="userImage" alt="User Image" class="img-fluid rounded-circle" width="100">
                                        </div>

                                            <div class="d-flex flex-column text-start me-2 mx-3">
                                                <p>Name</p>
                                                <p>Id</p>
                                                <p>Grade</p>
                                                <p>Contact</p>
                                                <p>Join Date</p>
                                            </div>

                                            <!-- Separator -->
                                            <div class="d-flex flex-column me-2">
                                                <p>:</p>
                                                <p>:</p>
                                                <p>:</p>
                                                <p>:</p>
                                                <p>:</p>
                                            </div>

                                            <!-- Student Data -->
                                            <div class="data d-flex flex-column justify-content-start me-2 mx-3">
                                                <p id="studentName"></p>
                                                <p id="studentId"></p>
                                                <p id="studentGrade"></p>
                                                <p id="studentContact"></p>
                                                <p id="studentjDate"></p>
                                            </div>
                                        <!-- Labels -->
                                    </div>
                                </div>
                                <!-- <div class="card bg-primary text-white mb-4">
                                    <div class="card-body">Primary Card</div>
                                    <div class="card-footer d-flex align-items-center justify-content-between">
                                        <a class="small text-white stretched-link" href="#">View Details</a>
                                        <div class="small text-white"><i class="fas fa-angle-right"></i></div>
                                    </div>
                                </div> -->
                            </div>
                        </div>
                        <div class="card border-warning mb-4">
                            <div class="card-header bg-transparent border-warning d-flex justify-content-center align-items-center">
                                <span>
                                    <i class="fa-solid fa-cart-shopping me-1"></i>Your Purchased Videos : <span class="badge bg-success" id="videoCount">0</span> <!-- Count Badge -->
                                </span>
                            </div>
                            <div class="card-body text-success">
                                <div class="table-responsive">
                                    <table id="purchasedVideosTbl" class="table table-hover" style="width:100%">
                                        <thead style="font-size: 13px;">
                                            <tr>
                                                <!-- Table headers will be dynamically added in JavaScript -->
                                            </tr>
                                        </thead>
                                        <tbody style="font-size: 13px;">
                                            <!-- Rows will be dynamically added in JavaScript -->
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </main>
                <?php include 'includes/footer.php' ?>
            </div>
        </div>
        <?php include 'includes/js.php' ?>

        <script>
            $(document).ready(function () {
                loadPurchasedVideos();  // Load the approved students into the table on page load
            });
             // Fetch student details using session-based user ID
            fetch('controller/getuserimage.php')
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        document.getElementById('userImage').src = data.data.imageUrl;
                        document.getElementById('studentName').innerText = data.data.Sfname + " " + data.data.Slname;
                        document.getElementById('studentGrade').innerText = data.data.Sgrade;
                        document.getElementById('studentContact').innerText = data.data.SContact;
                        document.getElementById('studentjDate').innerText = data.data.Sadddate;
                        document.getElementById('studentId').innerText = data.data.Sid;
                    } else {
                        console.error('Error:', data.message);
                    }
            })
            .catch(error => console.error('Error fetching student details:', error));

            function loadPurchasedVideos() {
                $.ajax({
                    type: "POST",
                    url: "controller/getpurchasedvideos.php", // Your endpoint to fetch purchased videos
                    dataType: "json",
                    success: function (data) {
                        console.log(data); // Debug: Check the structure of the response

                        // Clear existing table rows
                        $("#purchasedVideosTbl tbody").empty();

                        // Set table headers (if needed)
                        if ($("#purchasedVideosTbl thead th").length === 0) {
                            var tableHeaders =
                                "<th scope='col'>No</th>" +
                                "<th scope='col'>Video Id</th>" +
                                "<th scope='col'>Video Title</th>" +
                                "<th scope='col'>Subtitle</th>" +
                                "<th scope='col'>Video Name</th>" +
                                "<th scope='col'>Prchased Date</th>" +
                                "<th scope='col'>Expiry Date</th>" +
                                "<th scope='col'>Action</th>";
                            $("#purchasedVideosTbl thead tr").html(tableHeaders);
                        }

                        // Count purchased videos
                        $("#videoCount").text(data.length);

                        // Iterate through the received data and append rows
                        $.each(data, function (index, row) {
                            var newRow =
                                "<tr><td>" + (index + 1) + "</td>" + // Index as the row number
                                "<td>" + row.videoId + "</td>" +
                                "<td>" + row.maintitle + "</td>" +
                                "<td>" + row.subtitle + "</td>" +
                                "<td>" + row.sttwoName + "</td>" +
                                "<td>" + row.sDate + "</td>" +
                                "<td>" + row.exDate + "</td>" +
                                "<td>" +
                                '<a href="' + row.videourl + '" target="_blank" class="btn btn-sm btn-outline-primary">Watch</a>' +
                                "</td></tr>";

                            // Append the new row to the table
                            $("#purchasedVideosTbl tbody").append(newRow);
                        });

                        // Initialize DataTable only if it is not already initialized
                        if (!$.fn.dataTable.isDataTable('#purchasedVideosTbl')) {
                            $('#purchasedVideosTbl').DataTable({
                                paging: true,
                                scrollY: '300px',
                                scrollX: true,
                                scrollCollapse: true,
                            });
                        } else {
                            // If DataTable is already initialized, just reload the table data
                            $('#purchasedVideosTbl').DataTable().clear().rows.add($("#purchasedVideosTbl tbody tr")).draw();
                        }
                    },
                    error: function (xhr, status, error) {
                        console.error("Error loading data: ", error);
                    }
                });
            }
        </script>
    </body>
</html>
