<?php include 'includes/head.php' ?>
    <style>
        .body {
            background: url('images/background/back14.jpg') no-repeat center center/cover;
            position: relative;
            padding: 20px;
        }
        /* Overlay to create blur effect */
        .body::before {
            content: "";
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: inherit;
            filter: blur(3px); /* Adjust blur intensity */
            z-index: -1;
        }
        .grade {
            display: inline-block;
            background: linear-gradient(45deg, #ff6600, #ffcc00); /* Gradient effect */
            color: white; /* Text color */
            padding: 8px 16px; /* Add some spacing */
            border-radius: 8px; /* Rounded corners */
            font-weight: bold;
            font-size: 18px; /* Adjust font size */
            font-family: 'Poppins', sans-serif; /* Beautiful font */
            box-shadow: 2px 2px 10px rgba(0, 0, 0, 0.2); /* Shadow effect */
            transition: transform 0.3s ease-in-out, box-shadow 0.3s ease-in-out;
            /* backdrop-filter: blur(10px);
            background: rgba(255, 102, 0, 0.7); */
        }

        /* Hover effect */
        .grade:hover {
            transform: scale(1.05);
            box-shadow: 4px 4px 15px rgba(0, 0, 0, 0.3);
        }
        .card {
            background: rgba(255, 255, 255, 0.2); /* Semi-transparent white */
            backdrop-filter: blur(5px); /* Apply blur effect */
            border-radius: 12px; /* Rounded corners */
            padding: 15px;
            box-shadow: 0px 4px 10px rgba(0, 0, 0, 0.2); /* Soft shadow */
            transition: all 0.3s ease-in-out;
        }

        /* Optional: Hover Effect for better interaction */
        .card:hover {
            backdrop-filter: blur(15px);
            box-shadow: 0px 6px 15px rgba(0, 0, 0, 0.3);
        }
    </style>
    <body class="body sb-nav-fixed">
        
        <?php include 'includes/topnav.php' ?>
        <div id="layoutSidenav">
            <?php include 'includes/sidenav.php' ?>
            <div id="layoutSidenav_content">
                <main>
                    <div class="row">
                        <div class="col-12 grid-margin stretch-card">
                            <div class="card border-warning mt-2">
                                <div class="row">
                                    <div class="col-lg-12 col-md-12">
                                        <div class="card-body">
                                            <h5 class="card-title">Your Lessons</h5>
                                            <h6 class="grade text-center">Grade : <span id="sgrade"><?= $_SESSION['sgrade']?></span></h6>
                                            <div class="container mt-4">
                                                <div id="dropdownContainer" class="row">
                                                    <!-- Dropdowns will be added dynamically inside rows -->
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </main>
                <?php include 'includes/footer.php' ?>
            </div>
        </div>
        <?php include 'includes/js.php' ?>

        <Script>
            $(document).ready(function () {
                $.ajax({
                    url: "controller/getmaintittle.php",
                    type: "POST",
                    dataType: "json",
                    success: function (response) {
                        console.log(response); // Debugging output

                        var dropdownContainer = $("#dropdownContainer");
                        dropdownContainer.empty();

                        if (response.status === "success" && response.data.length > 0) {
                            var hasLessons = false; // Track if at least one lesson exists
                            var rowDiv = $('<div class="row"></div>');

                            $.each(response.data, function (index, item) {
                                var subtitlesHtml = "";

                                if (item.subtitles.length > 0) {
                                    hasLessons = true; // At least one lesson exists
                                    $.each(item.subtitles, function (subIndex, subtitle) {
                                        subtitlesHtml += `<li>
                                            <a class="dropdown-item" href="video.php?stoneId=${subtitle.stoneId}&stName=${encodeURIComponent(subtitle.stName)}">
                                                ${subtitle.stName}
                                            </a>
                                        </li>`;
                                    });
                                } else {
                                    subtitlesHtml = `<li><a class="dropdown-item" href="#">No Lessons Available</a></li>`;
                                }

                                var dropdownHTML = `
                                    <div class="col-lg-3 col-md-6 col-sm-12 mt-2">
                                        <div class="dropdown-center">
                                            <button class="btn btn-dark dropdown-toggle w-100" type="button" data-bs-toggle="dropdown">
                                                <span class="tittleId mx-2">${item.tId} - ${item.tName}</span>
                                            </button>
                                            <ul class="dropdown-menu">
                                                ${subtitlesHtml}
                                            </ul>
                                        </div>
                                    </div>`;

                                rowDiv.append(dropdownHTML);

                                if ((index + 1) % 4 === 0) {
                                    dropdownContainer.append(rowDiv);
                                    rowDiv = $('<div class="row"></div>');
                                }
                            });

                            if (rowDiv.children().length > 0) {
                                dropdownContainer.append(rowDiv);
                            }

                            // If no lessons exist, show a message
                            if (!hasLessons) {
                                dropdownContainer.html("<p class='text-danger text-center fw-bold'>No lessons available for your grade.</p>");
                            }
                        } else {
                            dropdownContainer.html("<p class='text-danger text-center fw-bold'>No lessons available for your grade.</p>");
                        }
                    },
                    error: function (xhr, status, error) {
                        console.error("AJAX Error: " + xhr.responseText);
                        $("#dropdownContainer").html("<p class='text-danger text-center fw-bold'>Something went wrong. Please try again.</p>");
                    }
                });
            });



        </Script>

    </body>
</html>
