<?php include 'includes/head.php' ?>
<?php
session_start();
include 'includes/conn.php';

if (isset($_POST['submit'])) {
    $errors = array();

    if (empty($_POST['loginEmail']) || empty($_POST['loginPassword'])) {
        $errors[] = 'Email and Password are required.';
    }

    if (empty($errors)) {
        $email = trim($_POST['loginEmail']);
        $password = $_POST['loginPassword'];

        // Debug: Check if the form is submitting correctly
        error_log("Form submitted with email: $email");

        // Use prepared statements to prevent SQL injection
        $query = "SELECT * FROM studenttbl WHERE Semail = ? LIMIT 1";
        $stmt = $connection->prepare($query);
        
        if (!$stmt) {
            die("Database error: " . $connection->error);
        }

        $stmt->bind_param("s", $email);
        $stmt->execute();
        $result_set = $stmt->get_result();

        if ($result_set->num_rows === 1) {
            $user = $result_set->fetch_assoc();
            $stored_password = $user['Spassword'];

            // Debug: Ensure password is stored correctly
            error_log("Stored password hash: " . $stored_password);

            if ($user['Sstatus'] == 0) {
                $errors[] = "Your application is not approved. Please contact your class teacher.";
            } else {
                // ✅ Secure password verification
                if (password_verify($password, $stored_password)) {
                    $_SESSION['studentid'] = $user['Sid'];
                    $_SESSION['sfname'] = $user['Sfname'];
                    $_SESSION['slname'] = $user['Slname'];
                    $_SESSION['sgrade'] = $user['Sgrade'];
                    $_SESSION['jRole'] = $user['jRole'];

                    // Debug: Check if session is set properly
                    error_log("Session set for user: " . $_SESSION['studentid']);

                    // ✅ Update last login
                    $update_query = "UPDATE studenttbl SET Slastlogin = NOW() WHERE Sid = ?";
                    $update_stmt = $connection->prepare($update_query);

                    if (!$update_stmt) {
                        die("Database error: " . $connection->error);
                    }

                    $update_stmt->bind_param("i", $_SESSION['studentid']);
                    $update_stmt->execute();

                    if ($update_stmt->affected_rows === 0) {
                        die("Failed to update last login.");
                    }

                    header('Location: index.php');
                    exit();
                } else {
                    $errors[] = 'Invalid email or password.';
                }
            }
        } else {
            $errors[] = 'Invalid email or password.';
        }
    }

    $_SESSION['login_errors'] = $errors;
    header("Location: login.php");
    exit();
}
?>

<style>
    body {
        background-image: url('images/login/english-pictures-62thzly2s31pvnda.jpg'); 
        background-size: cover;
        background-repeat: no-repeat;
        background-position: center;
        height: 100vh;
        margin: 0;
        /* display: flex; */
        align-items: center;
        justify-content: center;
    }

    .card {
      max-width: 100%; /* Full width */
      margin: auto;
      background-color: rgba(255, 255, 255, 0.8); /* Semi-transparent white */
      box-shadow: 0 4px 6px rgba(0, 0, 0, 0.2); /* Soft shadow */
    }

    .card-header, .card-footer {
      background-color: rgba(255, 255, 255, 0.6); /* Slightly more transparent */
      border-bottom: none;
    }

    .btn-primary {
      font-size: 0.875rem;
      padding: 0.5rem 1rem;
    }

    .form-floating .form-control {
      background-color: rgba(255, 255, 255, 0.7); /* Transparent input fields */
      border: 1px solid rgba(0, 0, 0, 0.1);
      height: 35px; /* Custom height for smaller input */
      padding: 0.375rem 0.75rem; /* Custom padding for smaller input */
      font-size: 0.875rem; /* Smaller font size */
    }

    .form-floating .form-control:focus {
      background-color: rgba(255, 255, 255, 0.9); /* Slightly less transparent when focused */
      border-color: rgba(106, 17, 203, 0.5);
      box-shadow: 0 0 5px rgba(106, 17, 203, 0.5);
    }
  </style>
    <!-- <body class="bg-primary"> -->
    <body>
        <div id="layoutAuthentication">
            <div id="layoutAuthentication_content">
                <main>
                    <div class="container">
                        <!-- Register Button -->
                        <div class="row">
                            <div class="d-flex justify-content-end">
                            <button type="button" class="btn btn-sm btn-primary mb-3 mt-5"
                                    data-bs-toggle="collapse" data-bs-target="#collapseRegisterForm"
                                    aria-expanded="false" aria-controls="collapseRegisterForm"
                                    onclick="scrollToRegisterForm()">
                                <i class="fa-solid fa-id-card me-2"></i> Register
                            </button>
                            </div>
                        </div>

                        <!-- Display Success or Error Alert -->
                        <?php if (isset($_SESSION['success_message'])): ?>
                            <div class="alert alert-success alert-dismissible fade show" role="alert">
                                <?php echo $_SESSION['success_message']; ?>
                                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                            </div>
                            <?php unset($_SESSION['success_message']); ?>
                        <?php endif; ?>

                        <?php if (isset($_SESSION['error_message'])): ?>
                            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                                <?php echo $_SESSION['error_message']; ?>
                                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                            </div>
                            <?php unset($_SESSION['error_message']); ?>
                        <?php endif; ?>

                        <!-- Register Form -->
                        <div class="row d-flex justify-content-center">
                            <div class="collapse col-lg-10" id="collapseRegisterForm">
                            <div class="card card-body p-3 mb-5 rounded">
                                <div class="card-header text-center">
                                <h5>Register Form</h5>
                                <span id="currdate" class="bold-and-large mx-2"></span>
                                </div>
                                <form action="controller/register.php" method="POST" enctype="multipart/form-data">
                                <div class="row">
                                <input type="hidden" id="hiddenCurrDate" name="currdate">
                                    <div class="col-lg-4">
                                    <div class="input-group-sm mb-2">
                                        <label for="inputSfname" class="form-label">First Name</label>
                                        <input type="text" class="form-control" id="inputSfname" name="inputSfname" placeholder="Student First Name here">
                                    </div>
                                    </div>
                                    <div class="col-lg-4">
                                    <div class="input-group-sm mb-2">
                                        <label for="inputSlname" class="form-label">Last Name</label>
                                        <input type="text" class="form-control" id="inputSlname" name="inputSlname" placeholder="Student Last Name here">
                                    </div>
                                    </div>
                                    <!-- <div class="col-lg-4 d-flex justify-content-end">
                                    <div class="input-group-sm mb-2">
                                        <label for="currentDate" class="form-label">Date</label>
                                        <input type="date" class="form-control" id="currentDate" name="currentDate" disabled>
                                    </div>
                                    </div> -->
                                </div>
                                <div class="row">
                                    <div class="col-lg-12 mt-3">
                                    <h5 class="card-title">Address</h5>
                                    <div class="row">
                                        <div class="col-lg-4">
                                            <div class="input-group-sm mb-2">
                                                <label for="inputAdd1" class="form-label">Line 01</label>
                                                <input type="text" class="form-control"
                                                    id="inputAdd1" name="inputAdd1" placeholder="Student Address here">
                                            </div>
                                        </div>
                                        <div class="col-lg-4">
                                            <div class="input-group-sm mb-2">
                                                <label for="inputAdd2"
                                                    class="form-label">Line 02</label>
                                                <input type="text" class="form-control"
                                                    id="inputAdd2" name="inputAdd2" placeholder="Student Address here">
                                            </div>
                                        </div>
                                        <div class="col-lg-4">
                                            <div class="input-group-sm mb-2">
                                                <label for="inputScity"
                                                    class="form-label">City</label>
                                                <input type="text" class="form-control"
                                                    id="inputScity" name="inputScity" placeholder="Student City">
                                            </div>
                                        </div>
                                    </div>
                                    </div>    
                                </div>
                                <div class="row mt-3">
                                    <div class="col-lg-2">
                                    <div class="input-group-sm mb-2">
                                        <label for="inputSbd" class="form-label">Birth day</label>
                                        <input type="text" class="form-control" id="inputSbd" name="inputSbd" placeholder="Student Birthday here">
                                    </div>
                                    </div>
                                    <div class="col-lg-1">
                                    <div class="input-group-sm mb-2">
                                        <label for="inputSage" class="form-label">Age</label>
                                        <input type="text" class="form-control" id="inputSage" name="inputSage" placeholder="Age">
                                    </div>
                                    </div>
                                    <!-- <div class="col-lg-4">
                                    <div class="input-group-sm mb-2">
                                        <label for="userContact" class="form-label">Target grade</label>
                                        <input type="text" class="form-control" id="userContact" name="userContact" placeholder="Contact">
                                    </div>
                                    </div> -->
                                    <div class="col-lg-3">
                                    <label for="gender" class="form-label mb-2">Gender</label>
                                    <select class="form-select form-select-sm" id="inputSgender" name="inputSgender">
                                        <option value="Male">Male</option>
                                        <option value="Female">Female</option>
                                        <option value="Other">Other</option>
                                    </select>
                                    </div>
                                    <div class="col-lg-3">
                                    <label for="grade" class="form-label mb-2">Grade</label>
                                    <select class="form-select form-select-sm" id="inputSgrade" name="inputSgrade">
                                        <option value="6">G 6</option>
                                        <option value="7">G 7</option>
                                        <option value="8">G 8</option>
                                        <option value="9">G 9</option>
                                        <option value="10">G 10</option>
                                    </select>
                                    </div>
                                    <div class="col-lg-3">
                                    <div class="input-group-sm mb-2">
                                        <label for="inputSschool" class="form-label">School</label>
                                        <input type="text" class="form-control" id="inputSschool" name="inputSschool" placeholder="Student School here">
                                    </div>
                                    </div>
                                </div>
                                <div class="row mt-3">
                                    <div class="col-lg-12 mt-3">
                                    <h5 class="card-title">Contact Details</h5>
                                    <div class="row">
                                        <div class="col-lg-4">
                                            <div class="input-group-sm mb-2">
                                                <label for="inputScontact" class="form-label">Contact</label>
                                                <input type="text" class="form-control"
                                                    id="inputScontact" name="inputScontact" placeholder="Student Contact No. here">
                                            </div>
                                        </div>
                                        <div class="col-lg-4">
                                            <div class="input-group-sm mb-2">
                                                <label for="inputWAno"
                                                    class="form-label">WhatsApp</label>
                                                <input type="text" class="form-control"
                                                    id="inputWAno" name="inputWAno" placeholder="Student WhatsApp No here">
                                            </div>
                                        </div>
                                    </div>
                                    </div>    
                                </div>
                                <div class="row mt-3">
                                    <div class="col-lg-12 mt-3">
                                    <h5 class="card-title">About Guardian</h5>
                                    <div class="row">
                                        <div class="col-lg-4">
                                            <div class="input-group-sm mb-2">
                                                <label for="inputGname" class="form-label">Name</label>
                                                <input type="text" class="form-control"
                                                    id="inputGname" name="inputGname" placeholder="Guardian's Name here">
                                            </div>
                                        </div>
                                        <div class="col-lg-4">
                                            <div class="input-group-sm mb-2">
                                                <label for="inputGcontact"
                                                    class="form-label">Contact</label>
                                                <input type="text" class="form-control"
                                                    id="inputGcontact" name="inputGcontact" placeholder="Guardian's contact here">
                                            </div>
                                        </div>
                                    </div>
                                    </div>    
                                </div>
                                <div class="row mt-3">
                                    <div class="col-lg-12 mt-3">
                                    <h5 class="card-title">Login Details</h5>
                                    <div class="row">
                                        <div class="col-lg-4">
                                            <div class="input-group-sm mb-2">
                                                <label for="logginuserName" class="form-label">User Name / Email</label>
                                                <input type="text" class="form-control"
                                                    id="logginuserName" name="logginuserName" placeholder="User Name">
                                            </div>
                                        </div>
                                        <div class="col-lg-4">
                                            <div class="input-group-sm mb-2">
                                                <label for="loginuserPassword"
                                                    class="form-label">Password</label>
                                                <input type="Password" class="form-control"
                                                    id="loginuserPassword" name="loginuserPassword" placeholder="Password">
                                            </div>
                                        </div>
                                        <div class="col-lg-4">
                                            <div class="input-group-sm mb-2">
                                                <label for="inputuserSprofilepic"
                                                    class="form-label">Profile Picture</label>
                                                <input type="file" class="form-control"
                                                    id="inputuserSprofilepic" name="inputuserSprofilepic" placeholder="Prescription">
                                            </div>
                                        </div>
                                    </div>
                                    </div>    
                                </div>
                                <div class="row mt-3">
                                    <div class="d-flex justify-content-end">
                                    <button type="submit" class="btn btn-sm btn-outline-success mb-3" name="addnewstudentbtn"><i class="fa-solid fa-floppy-disk mx-2"></i>Submit Application
                                    </button>
                                    </div>
                                </div>
                                </form>
                            </div>
                            </div>
                        </div>

                        <div class="row justify-content-center">
                            <div class="col-lg-5">
                                <div class="card shadow-lg border-0 rounded-lg mt-5">
                                    <div class="card-header"><h3 class="text-center font-weight-light my-4">Login</h3></div>
                                        <div class="card-body">
                                            <form action="login.php" method="post" enctype="multipart/form-data">
                                                <?php
                                                if (!empty($errors)) {
                                                    echo '<div class="alert alert-danger">';
                                                    foreach ($errors as $error) {
                                                        echo "<p>$error</p>";
                                                    }
                                                    echo '</div>';
                                                }
                                                ?>
                                                <div class="form-floating mb-3">
                                                <input type="email" class="form-control" name="loginEmail" id="loginEmail" placeholder="name@example.com">
                                                <label for="loginEmail">Email address</label>
                                                </div>
                                                <div class="form-floating mb-3">
                                                <input type="password" class="form-control" name="loginPassword" id="loginPassword" placeholder="Password">
                                                <label for="loginPassword">Password</label>
                                                </div>
                                                <!-- <button type="button" class="btn btn-primary mt-3">Login</button> -->
                                                <button type="submit" name="submit" class="btn btn-primary mt-3">Login</button>
                                            </form>
                                    </div>
                                    <div class="card-footer text-center py-3">
                                        <div class="small"><a href="register.html">Need an account? Sign up!</a></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </main>
            </div>
            <div id="layoutAuthentication_footer">
                <?php include 'includes/footer.php' ?>
            </div>
        </div>
        <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.bundle.min.js" crossorigin="anonymous"></script>
        <script src="js/scripts.js"></script>
        <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

        <script>
        $(document).ready(function () {
            // Function to get the current date in YYYY-MM-DD format
            function getCurrentDate() {
                var date = new Date();
                var day = String(date.getDate()).padStart(2, '0'); // Get day with leading zero if needed
                var month = String(date.getMonth() + 1).padStart(2, '0'); // Get month (add 1 as months are 0-based)
                var year = date.getFullYear();
                return year + '-' + month + '-' + day; // Return date in YYYY-MM-DD format
            }

            // Set current date in the currdate span and hiddenCurrDate input
            var currentDate = getCurrentDate();
            document.getElementById("currdate").innerText = currentDate; // Display in span
            document.getElementById("hiddenCurrDate").value = currentDate; // Set value in hidden input
            console.log(currentDate);
        });
        </script>
    </body>
</html>
