<?php session_start(); ?>
<?php include 'includes/head.php' ?>
    <body class="sb-nav-fixed">
        <style>
            #studentImage {
            width: 100%; /* Adjust percentage as needed */
            max-width: 200px; /* Prevent it from getting too large */
            height: auto; /* Maintain aspect ratio */
            object-fit: cover;
            }
        </style>
        <?php include 'includes/topnav.php' ?>
        <div id="layoutSidenav">
            <?php include 'includes/sidenav.php' ?>
            <div id="layoutSidenav_content">
                <main>
                    <div class="row mx-2">
                        <div class="col-12 grid-margin stretch-card">
                            <div class="card mt-2">
                                <div class="row d-flex ">
                                    <div class="col-lg-6 col-md-12">
                                        <div class="card-body">
                                            <div class="row">
                                                <div class="d-flex justify-content-start">
                                                <h6 class="card-title">Pending Requests</h6>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-6 col-md-12">
                                        <div class="card-body">
                                            <div class="row">
                                                <div class="d-flex justify-content-end">
                                                <button type="button" class="btn btn-sm btn-primary mb-3"
                                                    data-bs-toggle="collapse" data-bs-target="#collapseAddvideo"
                                                    aria-expanded="false" aria-controls="collapseAddvideo"><i
                                                    class="fa-solid fa-plus mx-2"></i>Add New
                                                </button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- start add user collapse -->
                                    <div class="collapse" id="collapseAddvideo">
                                        <div class="container">
                                        <div class="card card-body p-3 mb-5 rounded">
                                            <form action="controller/addnewuser.php" method="POST" enctype="multipart/form-data">
                                            <div class="row">
                                                <div class="col-lg-4">
                                                <div class="input-group-sm mb-2">
                                                    <label for="inputSfname" class="form-label">First Name</label>
                                                    <input type="text" class="form-control" id="inputSfname" name="inputSfname" placeholder="Student First Name here">
                                                </div>
                                                </div>
                                                <div class="col-lg-4">
                                                <div class="input-group-sm mb-2">
                                                    <label for="inputSlname" class="form-label">Last Name</label>
                                                    <input type="text" class="form-control" id="inputSlname" name="inputSlname" placeholder="Student Last Name here">
                                                </div>
                                                </div>
                                                <!-- <div class="col-lg-4">
                                                <div class="input-group-sm mb-2">
                                                    <label for="inputVideodescription" class="form-label">Description</label>
                                                    <input type="text" class="form-control" id="inputVideodescription" name="inputVideodescription" placeholder="Video Dscription">
                                                </div>
                                                </div> -->
                                            </div>
                                            <div class="row">
                                                <div class="col-lg-12 mt-3">
                                                <h5 class="card-title">Address</h5>
                                                <div class="row">
                                                    <div class="col-lg-4">
                                                        <div class="input-group-sm mb-2">
                                                            <label for="inputAdd1" class="form-label">Line 01</label>
                                                            <input type="text" class="form-control"
                                                                id="inputAdd1" name="inputAdd1" placeholder="Student Address here">
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-4">
                                                        <div class="input-group-sm mb-2">
                                                            <label for="inputAdd2"
                                                                class="form-label">Line 02</label>
                                                            <input type="text" class="form-control"
                                                                id="inputAdd2" name="inputAdd2" placeholder="Student Address here">
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-4">
                                                        <div class="input-group-sm mb-2">
                                                            <label for="inputScity"
                                                                class="form-label">City</label>
                                                            <input type="text" class="form-control"
                                                                id="inputScity" name="inputScity" placeholder="Student City">
                                                        </div>
                                                    </div>
                                                </div>
                                                </div>    
                                            </div>
                                            <div class="row mt-3">
                                                <div class="col-lg-3">
                                                <div class="input-group-sm mb-2">
                                                    <label for="inputSage" class="form-label">Age</label>
                                                    <input type="text" class="form-control" id="inputSage" name="inputSage" placeholder="Student Age here">
                                                </div>
                                                </div>
                                                <!-- <div class="col-lg-4">
                                                <div class="input-group-sm mb-2">
                                                    <label for="userContact" class="form-label">Target grade</label>
                                                    <input type="text" class="form-control" id="userContact" name="userContact" placeholder="Contact">
                                                </div>
                                                </div> -->
                                                <div class="col-lg-3">
                                                <label for="gender" class="form-label mb-2">Gender</label>
                                                <select class="form-select form-select-sm" id="inputSgender" name="inputSgender">
                                                    <option value="gender">Male</option>
                                                    <option value="gender">Female</option>
                                                    <option value="gender">Other</option>
                                                </select>
                                                </div>
                                                <div class="col-lg-3">
                                                <label for="grade" class="form-label mb-2">Grade</label>
                                                <select class="form-select form-select-sm" id="inputSgrade" name="inputSgrade">
                                                    <option value="grade">G 6</option>
                                                    <option value="grade">G 7</option>
                                                    <option value="grade">G 8</option>
                                                    <option value="grade">G 9</option>
                                                    <option value="grade">G 10</option>
                                                </select>
                                                </div>
                                                <div class="col-lg-3">
                                                <div class="input-group-sm mb-2">
                                                    <label for="inputSschool" class="form-label">School</label>
                                                    <input type="text" class="form-control" id="inputSschool" name="inputSschool" placeholder="Student School here">
                                                </div>
                                                </div>
                                            </div>
                                            <div class="row mt-3">
                                                <div class="col-lg-12 mt-3">
                                                <h5 class="card-title">Contact Details</h5>
                                                <div class="row">
                                                    <div class="col-lg-4">
                                                        <div class="input-group-sm mb-2">
                                                            <label for="inputScontact" class="form-label">Contact</label>
                                                            <input type="text" class="form-control"
                                                                id="inputScontact" name="inputScontact" placeholder="Student Contact No. here">
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-4">
                                                        <div class="input-group-sm mb-2">
                                                            <label for="inputWAno"
                                                                class="form-label">WhatsApp</label>
                                                            <input type="text" class="form-control"
                                                                id="inputWAno" name="inputWAno" placeholder="Student WhatsApp No here">
                                                        </div>
                                                    </div>
                                                </div>
                                                </div>    
                                            </div>
                                            <div class="row mt-3">
                                                <div class="col-lg-12 mt-3">
                                                <h5 class="card-title">About Guardian</h5>
                                                <div class="row">
                                                    <div class="col-lg-4">
                                                        <div class="input-group-sm mb-2">
                                                            <label for="inputGname" class="form-label">Name</label>
                                                            <input type="text" class="form-control"
                                                                id="inputGname" name="inputGname" placeholder="Guardian's Name here">
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-4">
                                                        <div class="input-group-sm mb-2">
                                                            <label for="inputGcontact"
                                                                class="form-label">Contact</label>
                                                            <input type="text" class="form-control"
                                                                id="inputGcontact" name="inputGcontact" placeholder="Guardian's contact here">
                                                        </div>
                                                    </div>
                                                </div>
                                                </div>    
                                            </div>
                                            <div class="row mt-3">
                                                <div class="col-lg-12 mt-3">
                                                <h5 class="card-title">Login Details</h5>
                                                <div class="row">
                                                    <div class="col-lg-4">
                                                        <div class="input-group-sm mb-2">
                                                            <label for="logginuserName" class="form-label">User Name / Email</label>
                                                            <input type="text" class="form-control"
                                                                id="logginuserName" name="logginuserName" placeholder="User Name">
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-4">
                                                        <div class="input-group-sm mb-2">
                                                            <label for="loginuserPassword"
                                                                class="form-label">Password</label>
                                                            <input type="Password" class="form-control"
                                                                id="loginuserPassword" name="loginuserPassword" placeholder="Password">
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-4">
                                                        <div class="input-group-sm mb-2">
                                                            <label for="inputuserSprofilepic"
                                                                class="form-label">Profile Picture</label>
                                                            <input type="file" class="form-control"
                                                                id="inputuserSprofilepic" name="inputuserSprofilepic" placeholder="Prescription">
                                                        </div>
                                                    </div>
                                                </div>
                                                </div>    
                                            </div>
                                            <div class="row mt-3">
                                                <div class="d-flex justify-content-end">
                                                <button type="submit" class="btn btn-sm btn-outline-success mb-3" name="addnewuserbtn"><i class="fa-solid fa-floppy-disk mx-2"></i>Submit Details
                                                </button>
                                                </div>
                                            </div>
                                            </form>
                                        </div>
                                        </div>
                                    </div>
                                    <!-- end add new item collapse -->
                                    <div class="container-fluid px-4 mt-3">
                                        <table id="srequestingtbl" class="table table-striped table-row" style="width:100%">
                                            <thead>
                                                <tr>
                                                    <!-- <th>Id</th>
                                                    <th>Name</th>
                                                    <th>Birthday</th>
                                                    <th>Grade</th>
                                                    <th>City</th>
                                                    <th>School</th>
                                                    <th>Contact</th>
                                                    <th>Requested Date</th>
                                                    <th>Option</th>
                                                    <th>Status</th> -->
                                                </tr>
                                            </thead>
                                            <tbody>
                                                
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Student Details Modal -->
                    <div class="modal fade" id="studentDetailsModal" tabindex="-1" aria-labelledby="studentDetailsModalLabel" aria-hidden="true">
                        <div class="modal-dialog modal-xl">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="studentDetailsModalLabel">Student Details</h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                </div>
                                <div class="modal-body">
                                    <div class="row">
                                        <div class="col-md-4 text-center">
                                            <img id="studentImage" src="" alt="Student Image" class="img-fluid rounded shadow">
                                        </div>
                                        <div class="col-md-8">
                                            <div class="row">
                                                <div class="col-lg-2">
                                                    <label for="modalStudentId" class="form-label">Student Id</label>
                                                    <input type="text" class="form-control text-center" id="modalStudentId" name="modalStudentId" disabled>
                                                </div>
                                                <div class="col-lg-4">
                                                    <label for="modalStudentName" class="form-label">Student First Name</label>
                                                    <input type="text" class="form-control" id="modalStudentName" name="modalStudentName" disabled>
                                                </div>
                                                <div class="col-lg-4">
                                                    <label for="modalStudentNamel" class="form-label">Student Last Name</label>
                                                    <input type="text" class="form-control" id="modalStudentNamel" name="modalStudentNamel" disabled>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-lg-12 mt-3">
                                                    <h5 class="card-title">Address</h5>
                                                    <div class="row">
                                                        <div class="col-lg-4">
                                                            <div class="input-group-sm mb-2">
                                                                <label for="modalStudentadd1" class="form-label">Line 01</label>
                                                                <input type="text" class="form-control" id="modalStudentadd1" name="modalStudentadd1" disabled>
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-4">
                                                            <div class="input-group-sm mb-2">
                                                                <label for="modalStudentadd2"
                                                                    class="form-label">Line 02</label>
                                                                <input type="text" class="form-control"
                                                                    id="modalStudentadd2" name="modalStudentadd2" disabled>
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-4">
                                                            <div class="input-group-sm mb-2">
                                                                <label for="modalStudentcity"
                                                                    class="form-label">City</label>
                                                                <input type="text" class="form-control"
                                                                    id="modalStudentcity" name="modalStudentcity" disabled>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>  
                                            </div>
                                            <div class="row mt-3">
                                                <div class="col-lg-2">
                                                    <div class="input-group-sm mb-2">
                                                        <label for="modalStudentbd" class="form-label">Birth day</label>
                                                        <input type="text" class="form-control" id="modalStudentbd" name="modalStudentbd" disabled>
                                                    </div>
                                                </div>
                                                <div class="col-lg-1">
                                                    <div class="input-group-sm mb-2">
                                                        <label for="modalStudentage" class="form-label">Age</label>
                                                        <input type="text" class="form-control" id="modalStudentage" name="modalStudentage" disabled>
                                                    </div>
                                                </div>
                                                <div class="col-lg-3">
                                                    <label for="modalStudentgender" class="form-label mb-2">Gender</label>
                                                    <input type="text" class="form-control" id="modalStudentgender" name="modalStudentgender" disabled>
                                                </div>
                                                <div class="col-lg-3">
                                                    <label for="modalStudentgrade" class="form-label mb-2">Grade</label>
                                                    <input type="text" class="form-control" id="modalStudentgrade" name="modalStudentgrade" disabled>
                                                </div>
                                                <div class="col-lg-3">
                                                    <div class="input-group-sm mb-2">
                                                        <label for="modalStudentschool" class="form-label">School</label>
                                                        <input type="text" class="form-control" id="modalStudentschool" name="modalStudentschool" disabled>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row mt-3">
                                                <div class="col-lg-12 mt-3">
                                                    <h5 class="card-title">Contact Details</h5>
                                                    <div class="row">
                                                        <div class="col-lg-4">
                                                            <div class="input-group-sm mb-2">
                                                                <label for="modalStudentcontact" class="form-label">Contact</label>
                                                                <input type="text" class="form-control"
                                                                    id="modalStudentcontact" name="modalStudentcontact" disabled>
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-4">
                                                            <div class="input-group-sm mb-2">
                                                                <label for="modalStudentwa"
                                                                    class="form-label">WhatsApp</label>
                                                                <input type="text" class="form-control" id="modalStudentwa" name="modalStudentwa" disabled>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>    
                                            </div>
                                            <div class="row mt-3">
                                                <div class="col-lg-12 mt-3">
                                                    <h5 class="card-title">About Guardian</h5>
                                                    <div class="row">
                                                        <div class="col-lg-4">
                                                            <div class="input-group-sm mb-2">
                                                                <label for="modalStudentgname" class="form-label">Name</label>
                                                                <input type="text" class="form-control" id="modalStudentgname" name="modalStudentgname" disabled>
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-4">
                                                            <div class="input-group-sm mb-2">
                                                                <label for="modalStudentgcontact"
                                                                    class="form-label">Contact</label>
                                                                <input type="text" class="form-control"
                                                                    id="modalStudentgcontact" name="modalStudentgcontact" disabled>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>    
                                            </div>
                                            <div class="row mt-3">
                                                <div class="col-lg-12 mt-3">
                                                    <h5 class="card-title">Login Details</h5>
                                                    <div class="row">
                                                        <div class="col-lg-4">
                                                            <div class="input-group-sm mb-2">
                                                                <label for="modalStudentemail" class="form-label">User Name / Email</label>
                                                                <input type="text" class="form-control"
                                                                    id="modalStudentemail" name="modalStudentemail" disabled>
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-4">
                                                            <div class="input-group-sm mb-2">
                                                                <label for="modalStudentreqdate"
                                                                    class="form-label">Requested Date</label>
                                                                <input type="text" class="form-control"
                                                                    id="modalStudentreqdate" name="modalStudentreqdate" disabled>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>    
                                            </div>
                                            <!-- <p><strong>Name:</strong> <span id="modalStudentName"></span></p>
                                            <p><strong>Birthday:</strong> <span id="modalStudentBirthday"></span></p>
                                            <p><strong>Grade:</strong> <span id="modalStudentGrade"></span></p>
                                            <p><strong>City:</strong> <span id="modalStudentCity"></span></p>
                                            <p><strong>School:</strong> <span id="modalStudentSchool"></span></p>
                                            <p><strong>Contact:</strong> <span id="modalStudentContact"></span></p>
                                            <p><strong>Request Date:</strong> <span id="modalStudentRequestDate"></span></p> -->
                                        </div>
                                    </div>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row d-flex">
                        <div class="col-12 grid-margin stretch-card">
                            <div class="container-fluid">
                                <div class="card px-4 mt-2">
                                    <div class="card-body">
                                        <h6 class="card-title">Approved Student List</h6>
                                        <p class="card-description">List of Approved Students along with additional information.</p>
                                        <div class="table-responsive">
                                            <table id="sapprovedtbl" class="table table-hover text-center table-striped table-row" style="width:100%">
                                                <thead>
                                                    <tr>
                                                        <!-- <th>Id</th>
                                                        <th>Name</th>
                                                        <th>Birthday</th>
                                                        <th>Grade</th>
                                                        <th>City</th>
                                                        <th>School</th>
                                                        <th>Contact</th>
                                                        <th>Requested Date</th>
                                                        <th>Option</th>
                                                        <th>Status</th> -->
                                                    </tr>
                                                </thead>
                                                <tbody>
                                    
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                    </div>
                </main>
                <?php include 'includes/footer.php' ?>
            </div>
        </div>
        <?php include 'includes/js.php' ?>

        <script>
            $(document).ready(function () {
                loadTableData(); // Initial table load
                loadApprovedTableData();

                // Event listener for dynamically added .viewstudentdetails-btn
                $(document).on('click', '.viewstudentdetails-btn', function () {
                    var studentId = $(this).closest('tr').find('td:first').text(); // Get student ID from the row
                    console.log("View Details button clicked for Student ID:", studentId);

                    // Fetch student details via AJAX
                    $.ajax({
                        type: "POST",
                        url: "controller/getstudentdetails.php", // Endpoint to fetch student details
                        data: { Sid: studentId },
                        dataType: "json",
                        success: function (response) {
                            if (response.success) {
                                var student = response.data;

                                console.log(student.imageUrl);

                                // Populate modal fields
                                $('#studentImage').attr('src', student.imageUrl || 'default-image.jpg'); // Set student image
                                $('#modalStudentId').val(student.Sid);
                                $('#modalStudentName').val(student.Sfname);
                                $('#modalStudentNamel').val(student.Slname);
                                $('#modalStudentadd1').val(student.Sadd1);
                                $('#modalStudentadd2').val(student.Sadd2);
                                $('#modalStudentcity').val(student.Sadd3);
                                $('#modalStudentbd').val(student.Sbd);
                                $('#modalStudentage').val(student.Sage);
                                $('#modalStudentgender').val(student.Sgender);
                                $('#modalStudentgrade').val(student.Sgrade);
                                $('#modalStudentschool').val(student.Sschool);
                                $('#modalStudentcontact').val(student.SContact);
                                $('#modalStudentwa').val(student.ScontactWA);
                                $('#modalStudentgname').val(student.Sgname);
                                $('#modalStudentgcontact').val(student.Sgcontact);
                                $('#modalStudentemail').val(student.Semail);
                                $('#modalStudentreqdate').val(student.Sadddate);

                                // Show the modal
                                $('#studentDetailsModal').modal('show');
                            } else {
                                Swal.fire({
                                    icon: 'error',
                                    title: 'Error',
                                    text: 'Failed to fetch student details.',
                                    timer: 3000,
                                    showConfirmButton: false
                                });
                            }
                        },
                        error: function (xhr, status, error) {
                            console.error("Error fetching student details: ", error);
                        }
                    });
                });

                $(document).on('click', '.delete-btn', function () {
                    // Get the student ID from the row
                    var studentId = $(this).closest('tr').find('td:first').text();

                    // Show confirmation dialog
                    Swal.fire({
                        title: 'Are you sure?',
                        text: 'Do you want to remove this application?',
                        icon: 'warning',
                        showCancelButton: true,
                        confirmButtonColor: '#3085d6',
                        cancelButtonColor: '#d33',
                        confirmButtonText: 'Yes, remove it!'
                    }).then((result) => {
                        if (result.isConfirmed) {
                            // If confirmed, send AJAX to update the status
                            $.ajax({
                                type: "POST",
                                url: "controller/updatesstatus.php", // Update the endpoint to handle status updates
                                data: { Sid: studentId, Sstatus: 2 }, // Update status to 2 (removed)
                                success: function (response) {
                                    console.log("Application removed for student ID " + studentId + ": " + response);

                                    // Display success message
                                    Swal.fire({
                                        icon: 'success',
                                        title: 'Application Removed',
                                        text: 'The application has been marked as removed.',
                                        timer: 3000,
                                        showConfirmButton: false
                                    });

                                    // Reload table data to reflect the change
                                    loadTableData();
                                },
                                error: function (xhr, status, error) {
                                    console.error("Error updating status: ", error);

                                    // Display error message
                                    Swal.fire({
                                        icon: 'error',
                                        title: 'Error',
                                        text: 'Failed to remove the application. Please try again.',
                                        timer: 3000,
                                        showConfirmButton: false
                                    });
                                }
                            });
                        }
                    });
                });

                // Event listener for switch changes
                $(document).on('change', '.status-switch', function () {
                    var isChecked = $(this).is(':checked'); // Check the state of the switch
                    var studentId = $(this).data('id'); // Get the student ID
                    var newStatus = isChecked ? 1 : 0; // Determine the new status
                    var statusText = isChecked ? "Approved" : "Approval"; // Update text

                    // Update the text next to the switch
                    $("#statusText" + studentId).text(statusText);

                    // AJAX to update the status in the database
                    $.ajax({
                        type: "POST",
                        url: "controller/updatesstatus.php",
                        data: { Sid: studentId, Sstatus: newStatus },
                        success: function (response) {
                            console.log("Status updated for student ID " + studentId + ": " + response);

                            if (isChecked) {
                                Swal.fire({
                                    icon: 'success',
                                    title: 'Student Approved!',
                                    text: 'They can now log in using their username and password.',
                                    timer: 3000,
                                    showConfirmButton: false
                                });
                            } else {
                                Swal.fire({
                                    icon: 'info',
                                    title: 'Status Changed',
                                    text: 'Student status changed to "Approval".',
                                    timer: 3000,
                                    showConfirmButton: false
                                });
                            }

                            loadTableData();
                        },
                        error: function (xhr, status, error) {
                            console.error("Error updating status: ", error);
                        }
                    });
                });

                    // Event listener for switch changes in sapprovedtbl
                $(document).on('change', '.status-switchapproved', function () {
                    var studentId = $(this).data('id'); // Get the student ID
                    var isChecked = $(this).is(':checked'); // Check the state of the switch
                    var statusText = isChecked ? "Approved" : "Approval"; // Update text

                    // Ask for password before changing status
                    Swal.fire({
                        title: 'Enter Password',
                        input: 'password',
                        inputPlaceholder: 'Enter your password',
                        showCancelButton: true,
                        confirmButtonText: 'Confirm',
                        cancelButtonText: 'Cancel',
                        inputValidator: (value) => {
                            if (!value) {
                                return 'Password is required!';
                            }
                        }
                    }).then((result) => {
                        if (result.isConfirmed) {
                            var password = result.value;

                            // Validate password via AJAX
                            $.ajax({
                                type: "POST",
                                url: "controller/getpassword.php", // Endpoint to validate the password
                                data: { password: password },
                                success: function (response) {
                                console.log(response);
                                    if (response.success) {
                                        // If password is correct, update the status
                                        $.ajax({
                                            type: "POST",
                                            url: "controller/updatesstatus.php",
                                            data: { Sid: studentId, Sstatus: isChecked ? 1 : 0 },
                                            success: function (response) {
                                                console.log("Status updated for student ID " + studentId + ": " + response);
                                                Swal.fire({
                                                    icon: 'success',
                                                    title: 'Status Updated',
                                                    text: 'The student status has been updated.',
                                                    timer: 3000,
                                                    showConfirmButton: false
                                                });

                                                // Refresh tables to reflect the updated status
                                                loadTableData(); // Refresh srequestingtbl
                                                loadApprovedTableData(); // Refresh sapprovedtbl
                                            },
                                            error: function (xhr, status, error) {
                                                console.error("Error updating status: ", error);
                                            }
                                        });
                                    } else {
                                        // If password is incorrect
                                        Swal.fire({
                                            icon: 'error',
                                            title: 'Invalid Password',
                                            text: 'The password you entered is incorrect.',
                                            timer: 3000,
                                            showConfirmButton: false
                                        });

                                        // Reset the switch state to its original value
                                        $('#flexSwitch' + studentId).prop('checked', !isChecked);
                                    }
                                },
                                error: function (xhr, status, error) {
                                    console.error("Error validating password: ", error);
                                }
                            });
                        } else {
                            // If the user cancels or closes the dialog, reset the switch
                            $('#flexSwitch' + studentId).prop('checked', !isChecked);
                        }
                    });
                });
            });

            // Function to load and refresh table data
            function loadTableData() {
                $.ajax({
                    type: "POST",
                    url: "controller/getsrequest.php",
                    dataType: "json",
                    success: function (data) {
                        console.log(data); // Debug: Check the structure of the response

                        // Clear existing table rows
                        $("#srequestingtbl tbody").empty();

                        // Set table headers only if the table headers aren't already set
                        if ($("#srequestingtbl thead th").length === 0) {
                            var tableHeaders =
                                "<th scope='col'>Id</th>" +
                                "<th scope='col'>Name</th>" +
                                "<th scope='col'>Birthday</th>" +
                                "<th scope='col'>Grade</th>" +
                                "<th scope='col'>City</th>" +
                                "<th scope='col'>School</th>" +
                                "<th scope='col'>Contact</th>" +
                                "<th scope='col'>Req. Date</th>" +
                                "<th scope='col'>Option</th>" +
                                "<th scope='col'>Status</th>";
                            $("#srequestingtbl thead tr").html(tableHeaders);
                        }

                        // Iterate through the received data and append rows
                        $.each(data, function (index, row) {
                            var isChecked = row.Sstatus == 1 ? "checked" : ""; // Determine switch state
                            var statusText = row.Sstatus == 1 ? "Approved" : "Approval"; // Determine text

                            var newRow =
                                "<tr><td>" + row.Sid + "</td>" +
                                "<td>" + row.Sfname + "</td>" +
                                "<td>" + row.Sbd + "</td>" +
                                "<td>" + row.Sgrade + "</td>" +
                                "<td>" + row.Sadd3 + "</td>" +
                                "<td>" + row.Sschool + "</td>" +
                                "<td>" + row.Scontact + "</td>" +
                                "<td>" + row.Sadddate + "</td>" +
                                "<td>" +
                                '<button type="button" class="btn btn-sm btn-outline-info viewstudentdetails-btn" style="padding: 0.1rem 0.2rem; margin-right: 1px;"><i class="fa-solid fa-eye"></i></button>' +
                                '<button type="button" class="btn btn-sm btn-outline-danger delete-btn" style="padding: 0.1rem 0.2rem; margin-left: 3px;"><i class="fa-solid fa-trash"></i></button>' +
                                "</td>" +
                                "<td>" +
                                '<div class="d-flex align-items-center">' +
                                '<div class="form-check form-switch me-2">' +
                                '<input class="form-check-input status-switch" type="checkbox" role="switch" id="flexSwitch' + row.Sid + '" data-id="' + row.Sid + '" ' + isChecked + '>' +
                                '</div>' +
                                '<span class="status-text" id="statusText' + row.Sid + '">' + statusText + '</span>' +
                                "</div>" +
                                "</td></tr>";

                            $("#srequestingtbl tbody").append(newRow);
                        });

                        // Initialize DataTable only if it is not already initialized
                        if (!$.fn.dataTable.isDataTable('#srequestingtbl')) {
                            $('#srequestingtbl').DataTable({
                                paging: true,
                                scrollY: '300px',
                                scrollX: true,
                                scrollCollapse: true,
                            });
                        } else {
                            // If DataTable is already initialized, just reload the table data
                            $('#srequestingtbl').DataTable().clear().rows.add($("#srequestingtbl tbody tr")).draw();
                        }
                        // Refresh the sapprovedtbl table to reflect the updated list of approved students (Sstatus=1)
                        loadApprovedTableData();
                    },
                    error: function (xhr, status, error) {
                        console.error("Error loading data: ", error);
                    }
                });
            }

            function loadApprovedTableData() {
                $.ajax({
                    type: "POST",
                    url: "controller/getapprovedlist.php",  // A new endpoint that fetches approved students
                    dataType: "json",
                    success: function (data) {
                        console.log(data); // Debug: Check the structure of the response

                        // Clear existing table rows
                        $("#sapprovedtbl tbody").empty();

                        // Set table headers (if needed)
                        if ($("#sapprovedtbl thead th").length === 0) {
                            var tableHeaders =
                                "<th scope='col'>Id</th>" +
                                "<th scope='col'>Name</th>" +
                                "<th scope='col'>Birthday</th>" +
                                "<th scope='col'>Grade</th>" +
                                "<th scope='col'>City</th>" +
                                "<th scope='col'>School</th>" +
                                "<th scope='col'>Contact</th>" +
                                "<th scope='col'>Req. Date</th>" +
                                "<th scope='col'>Option</th>" +
                                "<th scope='col'>Status</th>";
                            $("#sapprovedtbl thead tr").html(tableHeaders);
                        }

                        // Iterate through the received data and append rows
                        $.each(data, function (index, row) {
                            var isChecked = row.Sstatus == 1 ? "checked" : ""; // Determine switch state
                            var statusText = row.Sstatus == 1 ? "Approved" : "Approval"; // Determine text

                            var newRow =
                                "<tr><td>" + row.Sid + "</td>" +
                                "<td>" + row.Sfname + "</td>" +
                                "<td>" + row.Sbd + "</td>" +
                                "<td>" + row.Sgrade + "</td>" +
                                "<td>" + row.Sadd3 + "</td>" +
                                "<td>" + row.Sschool + "</td>" +
                                "<td>" + row.Scontact + "</td>" +
                                "<td>" + row.Sadddate + "</td>" +
                                "<td>" +
                                '<button type="button" class="btn btn-sm btn-outline-info viewstudentdetails-btn" style="padding: 0.1rem 0.2rem; margin-right: 1px;"><i class="fa-solid fa-eye"></i></button>' +
                                '<button type="button" class="btn btn-sm btn-outline-danger deletestudent-btn" style="padding: 0.1rem 0.2rem; margin-left: 3px;"><i class="fa-solid fa-trash"></i></button>' +
                                "</td>" +
                                "<td>" +
                                '<div class="d-flex align-items-center">' +
                                '<div class="form-check form-switch me-2">' +
                                '<input class="form-check-input status-switchapproved" type="checkbox" role="switch" id="flexSwitch' + row.Sid + '" data-id="' + row.Sid + '" ' + isChecked + '>' +
                                '</div>' +
                                '<span class="status-text" id="statusText' + row.Sid + '">' + statusText + '</span>' +
                                "</div>" +
                                "</td></tr>";

                            $("#sapprovedtbl tbody").append(newRow);
                        });

                        // Initialize DataTable only if it is not already initialized
                        if (!$.fn.dataTable.isDataTable('#sapprovedtbl')) {
                            $('#sapprovedtbl').DataTable({
                                paging: true,
                                scrollY: '300px',
                                scrollX: true,
                                scrollCollapse: true,
                            });
                        } else {
                            // If DataTable is already initialized, just reload the table data
                            $('#sapprovedtbl').DataTable().clear().rows.add($("#sapprovedtbl tbody tr")).draw();
                        }
                    },
                    error: function (xhr, status, error) {
                        console.error("Error loading data: ", error);
                    }
                });
            }

            $(document).ready(function () {
                loadApprovedTableData();  // Load the approved students into the table on page load
            });

        </script>

    </body>
</html>
