<?php
session_start();
// Check if the user is an authenticated admin
if (!isset($_SESSION['userRole']) || $_SESSION['userRole'] !== 'admin') {
    header("Location: login.php");
    exit();
}

// Include database connection
include 'includes/conn.php';

// Fetch summary data for the dashboard
$totalStudents = 0;
$pendingStudents = 0;
$totalCourses = 0;

$queryTotalStudents = "SELECT COUNT(Sid) AS total FROM studenttbl";
$resultTotalStudents = $connection->query($queryTotalStudents);
if ($resultTotalStudents) {
    $totalStudents = $resultTotalStudents->fetch_assoc()['total'];
}

$queryPendingStudents = "SELECT COUNT(Uid) AS pending FROM usertbl WHERE uStatus = 0";
$resultPendingStudents = $connection->query($queryPendingStudents);
if ($resultPendingStudents) {
    $pendingStudents = $resultPendingStudents->fetch_assoc()['pending'];
}

$queryTotalCourses = "SELECT COUNT(VideoID) AS total FROM mainvideotbl";
$resultTotalCourses = $connection->query($queryTotalCourses);
if ($resultTotalCourses) {
    $totalCourses = $resultTotalCourses->fetch_assoc()['total'];
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css" rel="stylesheet">
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.13.7/css/jquery.dataTables.min.css">
    <style>
        body {
            background: linear-gradient(135deg, #e3f2fd, #bbdefb);
            font-family: 'Poppins', sans-serif;
        }
        .dashboard-card {
            background: #fff;
            border-radius: 12px;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.05);
            transition: transform 0.3s ease, box-shadow 0.3s ease;
        }
        .dashboard-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 25px rgba(0, 0, 0, 0.1);
        }
        .icon-box {
            background-color: #6c63ff;
            color: #fff;
            border-radius: 8px;
            padding: 1.5rem;
            display: inline-flex;
            justify-content: center;
            align-items: center;
        }
    </style>
</head>
<body class="sb-nav-fixed">
    <?php include 'includes/topnav.php'; ?>
    <div id="layoutSidenav">
        <?php include 'includes/sidenav.php'; ?>
        <div id="layoutSidenav_content">
            <main>
                <div class="container-fluid px-4 mt-4">
                    <h1 class="fw-bold mb-4">Admin Dashboard</h1>
                    <div class="row g-4 mb-4">
                        <div class="col-lg-4 col-md-6">
                            <div class="card dashboard-card p-4">
                                <div class="d-flex justify-content-between align-items-center">
                                    <div>
                                        <p class="text-muted mb-0">Total Students</p>
                                        <h2 class="fw-bold mt-1 text-primary"><?php echo $totalStudents; ?></h2>
                                    </div>
                                    <div class="icon-box">
                                        <i class="fas fa-users fa-2x"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-4 col-md-6">
                            <div class="card dashboard-card p-4">
                                <div class="d-flex justify-content-between align-items-center">
                                    <div>
                                        <p class="text-muted mb-0">Pending Applications</p>
                                        <h2 class="fw-bold mt-1 text-warning"><?php echo $pendingStudents; ?></h2>
                                    </div>
                                    <div class="icon-box bg-warning">
                                        <i class="fas fa-user-plus fa-2x"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-4 col-md-6">
                            <div class="card dashboard-card p-4">
                                <div class="d-flex justify-content-between align-items-center">
                                    <div>
                                        <p class="text-muted mb-0">Total Courses</p>
                                        <h2 class="fw-bold mt-1 text-success"><?php echo $totalCourses; ?></h2>
                                    </div>
                                    <div class="icon-box bg-success">
                                        <i class="fas fa-book-open fa-2x"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="card p-4 mb-4">
                        <h4 class="fw-bold mb-4">Student Management</h4>
                        <div class="table-responsive">
                            <table id="studentTbl" class="table table-hover" style="width:100%">
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Name</th>
                                        <th>Email</th>
                                        <th>Grade</th>
                                        <th>Status</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    </tbody>
                            </table>
                        </div>
                    </div>
                    
                    <div class="card p-4 mb-4">
                        <h4 class="fw-bold mb-4">Course Management</h4>
                        <a href="add_course.php" class="btn btn-primary"><i class="fas fa-plus me-2"></i>Add New Course</a>
                        </div>
                </div>
            </main>
            <?php include 'includes/footer.php'; ?>
        </div>
    </div>
    
    <script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
    <script>
        $(document).ready(function() {
            // Initialize DataTables
            var studentTable = $('#studentTbl').DataTable({
                "ajax": {
                    "url": "controller/getallstudents.php",
                    "dataSrc": ""
                },
                "columns": [
                    { "data": "Sid" },
                    { "data": "Sfname", "render": function(data, type, row) { return row.Sfname + " " + row.Slname; } },
                    { "data": "Semail" },
                    { "data": "Sgrade" },
                    {
                        "data": "Sstatus",
                        "render": function(data, type, row) {
                            if (data == 1) {
                                return '<span class="badge bg-success">Approved</span>';
                            } else {
                                return '<span class="badge bg-warning text-dark">Pending</span>';
                            }
                        }
                    },
                    {
                        "data": null,
                        "render": function(data, type, row) {
                            if (row.Sstatus == 0) {
                                return `
                                    <button class="btn btn-success btn-sm approve-btn" data-id="${row.Sid}">Approve</button>
                                    <button class="btn btn-danger btn-sm deny-btn" data-id="${row.Sid}">Deny</button>
                                `;
                            } else {
                                return '<button class="btn btn-secondary btn-sm" disabled>Approved</button>';
                            }
                        }
                    }
                ]
            });

            // Handle approve and deny button clicks
            $('#studentTbl tbody').on('click', '.approve-btn', function() {
                var studentId = $(this).data('id');
                updateStudentStatus(studentId, 1);
            });
            $('#studentTbl tbody').on('click', '.deny-btn', function() {
                var studentId = $(this).data('id');
                updateStudentStatus(studentId, 2); // 2 could represent denied status
            });

            function updateStudentStatus(id, status) {
                $.ajax({
                    url: 'controller/updatestudentstatus.php',
                    type: 'POST',
                    dataType: 'json',
                    data: {
                        id: id,
                        status: status
                    },
                    success: function(response) {
                        if (response.success) {
                            alert(response.message);
                            studentTable.ajax.reload();
                        } else {
                            alert(response.message);
                        }
                    },
                    error: function(xhr, status, error) {
                        console.error('Error updating status:', error);
                        alert('Error updating student status.');
                    }
                });
            }
        });
    </script>
</body>
</html>