<?php
include '../includes/conn.php';
header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $videoTitleId = isset($_POST['videoTitleId']) ? intval($_POST['videoTitleId']) : 0;
    $subtitle = isset($_POST['subtitle']) ? trim($_POST['subtitle']) : '';

    if ($videoTitleId == 0 || empty($subtitle)) {
        echo json_encode(["success" => false, "error" => "Invalid data received"]);
        exit;
    }

    // Insert subtitle into database
    $query = "INSERT INTO subtittleonetbl (tId, stName) VALUES (?, ?)";
    $stmt = $connection->prepare($query);
    $stmt->bind_param("is", $videoTitleId, $subtitle);

    if ($stmt->execute()) {
        echo json_encode(["success" => true]);
    } else {
        echo json_encode(["success" => false, "error" => "Database error: " . $stmt->error]);
    }

    $stmt->close();
    $connection->close();
}
?>
