<?php
include '../includes/conn.php';
header('Content-Type: application/json');

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $titleName = isset($_POST['titleName']) ? trim($_POST['titleName']) : "";
    $targetGrade = isset($_POST['targetGrade']) ? $_POST['targetGrade'] : "";

    if (empty($titleName) || empty($targetGrade)) {
        echo json_encode(["success" => false, "error" => "All fields are required."]);
        exit;
    }

    // Use prepared statement to prevent SQL Injection
    $query = "INSERT INTO maintittletbl (tName, tGrade) VALUES (?, ?)";
    $stmt = mysqli_prepare($connection, $query);

    if ($stmt) {
        mysqli_stmt_bind_param($stmt, "si", $titleName, $targetGrade); // "si" means string, integer
        if (mysqli_stmt_execute($stmt)) {
            echo json_encode(["success" => true]);
        } else {
            echo json_encode(["success" => false, "error" => mysqli_error($connection)]);
        }
    } else {
        echo json_encode(["success" => false, "error" => "Database error."]);
    }
}
?>
