<?php
include '../includes/conn.php';

header('Content-Type: application/json');

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $userid = $_POST['userid'] ?? '';
    $videoId = $_POST['videoid'] ?? '';
    $studentid = $_POST['studentid'] ?? '';
    $jrole = $_POST['jrole'] ?? '';
    $vStatus = 1; // Set default status to 1

    // Validate data
    if (empty($userid) || empty($videoId) || empty($studentid) || empty($jrole)) {
        echo json_encode(["success" => false, "message" => "Missing required fields."]);
        exit;
    }

    // Get current date and calculate expiration date (2 weeks later)
    $sDate = date('Y-m-d'); // Current date
    $exDate = date('Y-m-d', strtotime('+2 weeks')); // Expiration date (current date + 2 weeks)

    // Insert into database
    $query = "INSERT INTO subscriptiontbl (userId, videoId, sDate, exDate, vStatus, subscribedBy, jRole) VALUES (?, ?, ?, ?, ?, ?, ?)";
    $stmt = mysqli_prepare($connection, $query);

    if ($stmt) {
        mysqli_stmt_bind_param($stmt, "iississ", $studentid, $videoId, $sDate, $exDate, $vStatus, $userid, $jrole);
        if (mysqli_stmt_execute($stmt)) {
            echo json_encode(["success" => true, "message" => "Subscription successful!", "sDate" => $sDate, "exDate" => $exDate]);
        } else {
            echo json_encode(["success" => false, "message" => "Database error."]);
        }
        mysqli_stmt_close($stmt);
    } else {
        echo json_encode(["success" => false, "message" => "Failed to prepare statement."]);
    }

    mysqli_close($connection);
} else {
    echo json_encode(["success" => false, "message" => "Invalid request method."]);
}
?>
