<?php
// Include database connection
include '../includes/conn.php';

header('Content-Type: application/json'); // Set response type to JSON
// Start the session and check if user is logged in
session_start();
if (!isset($_SESSION['studentid'])) {
    die("Access denied. Please log in.");
}

$Sid = $_SESSION['studentid']; // Get the logged-in student ID

// Fetch purchased videos for the logged-in student
$sql = "SELECT v.sttwoId, v.sttwoName, v.maintitle, v.subtitle, v.videourl, s.videoId, s.sDate, s.exDate 
        FROM subscriptiontbl s
        JOIN subtittletwotbl v ON s.videoId = v.sttwoId
        WHERE s.userId = ?";

$stmt = $connection->prepare($sql);
$stmt->bind_param("i", $Sid);
$stmt->execute();
$result = $stmt->get_result();

// Prepare the data to be sent back as JSON
$purchasedVideos = [];
while ($row = $result->fetch_assoc()) {
    $purchasedVideos[] = $row;
}

// Return the data as a JSON response
echo json_encode($purchasedVideos);

// Close the statement and connection
$stmt->close();
$connection->close();
?>
