<?php
// Disable notices/warnings to prevent breaking JSON output
error_reporting(0);

// Include database connection
include '../includes/conn.php';

// Set header for JSON response
header('Content-Type: application/json');

// Initialize empty array for response
$data = [];

// Check if search term is provided
if (isset($_GET['term'])) {
    $searchTerm = "%" . $_GET['term'] . "%";

    // Prepare query safely
    $query = "SELECT Uid, Ufname, Ulname, Ugrade FROM usertbl WHERE Uid LIKE ? OR Ufname LIKE ? LIMIT 10";
    $stmt = mysqli_prepare($connection, $query);

    if ($stmt) {
        mysqli_stmt_bind_param($stmt, "is", $searchTerm, $searchTerm);
        mysqli_stmt_execute($stmt);
        $result = mysqli_stmt_get_result($stmt);

        // Fetch all matching students
        while ($row = mysqli_fetch_assoc($result)) {
            $data[] = [
                "label"   => $row['Ufname'],          // Display in autocomplete
                "value"   => $row['Ufname'],          // Fill input field
                "id"      => $row['Uid'],             // Hidden ID
                "slname"  => $row['Ulname'],          // Last name
                "sgrade"  => $row['Ugrade']           // Grade
            ];
        }

        mysqli_stmt_close($stmt);
    }
}

// Return JSON response (even if empty)
echo json_encode($data);

// Close DB connection
mysqli_close($connection);
?>
