<?php
// Include database connection
include '../includes/conn.php';

// Set the Content-Type header to JSON
header('Content-Type: application/json');

// Check if the request method is POST
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Check if 'Sid' is provided
    if (isset($_POST['Sid'])) {
        $Sid = intval($_POST['Sid']); // Sanitize input to ensure it's an integer

        // Prepare the SQL query
        $stmt = $connection->prepare("SELECT * FROM studenttbl WHERE Sid = ?");
        if ($stmt) {
            $stmt->bind_param("i", $Sid);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                $student = $result->fetch_assoc();

                // Build the full image path based on the URL
                $imageFolder = 'http://localhost/PlusCoding_avenglish2/admin/images/profile/'; // Adjust based on your server URL
                $imageName = $student['Simage']; // Image name from the database
                $imagePath = $imageFolder . $imageName;

                // Check if the image file exists on the server
                if (file_exists(__DIR__ . '/../images/profile/' . $imageName) && !empty($imageName)) {
                    $student['imageUrl'] = $imagePath; // Set the image URL
                } else {
                    // Use a default image if the file is missing
                    $student['imageUrl'] = 'http://localhost/PlusCoding_avenglish/admin/images/profile/default-image.jpg';
                }

                // Return the student data with the image URL
                echo json_encode(["success" => true, "data" => $student]);
            } else {
                // Student not found
                echo json_encode(["success" => false, "message" => "Student not found."]);
            }
            $stmt->close();
        } else {
            // SQL statement preparation failed
            echo json_encode(["success" => false, "message" => "Failed to prepare database query."]);
        }
    } else {
        // 'Sid' not provided
        echo json_encode(["success" => false, "message" => "Student ID is required."]);
    }
} else {
    // Invalid request method
    echo json_encode(["success" => false, "message" => "Invalid request method."]);
}

// Close the database connection
$connection->close();
?>
