<?php
session_start();
include '../includes/conn.php';
header('Content-Type: application/json');

if (!isset($_SESSION['userId'])) {
    echo json_encode(['success' => false, 'message' => 'Access denied. Please login again.']);
    exit;
}

if (!isset($_POST['studentId'])) {
    echo json_encode(['success' => false, 'message' => 'Student ID missing']);
    exit;
}

$studentId = $_POST['studentId'];

$stmt = $conn->prepare("SELECT Uid, Ufname, Uemail, Ugrade, SContact FROM usertbl WHERE Uid = ?");
$stmt->bind_param("i", $studentId);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    $student = $result->fetch_assoc();
    echo json_encode(['success' => true, 'user' => $student]);
} else {
    echo json_encode(['success' => false, 'message' => 'Student not found']);
}
?>