<?php
include '../includes/conn.php';
header('Content-Type: application/json');

if (isset($_GET['id'])) {
    $videoId = intval($_GET['id']);

    $query = "SELECT sttwoId, maintitle, subtitle, sttwoName, videourl, videograde
              FROM subtittletwotbl 
              WHERE sttwoId = ?";
    $stmt = mysqli_prepare($connection, $query);

    if ($stmt) {
        mysqli_stmt_bind_param($stmt, "i", $videoId);
        mysqli_stmt_execute($stmt);
        $result = mysqli_stmt_get_result($stmt);

        if ($row = mysqli_fetch_assoc($result)) {
            echo json_encode($row); // ✅ Return single object
        } else {
            echo json_encode(null); // No record found
        }

        mysqli_stmt_close($stmt);
    } else {
        echo json_encode(["error" => "Query preparation failed"]);
    }
} else {
    echo json_encode(null); // No ID given
}

mysqli_close($connection);
?>
