<?php
include '../includes/conn.php';
header('Content-Type: application/json');
session_start();

// Ensure user is logged in
if (!isset($_SESSION['userId'])) {
    echo json_encode(["status" => "error", "message" => "Unauthorized access"]);
    exit();
}

$userId = $_SESSION['userId'];

// Get `stoneId` from URL
$stoneId = isset($_GET['stoneId']) ? intval($_GET['stoneId']) : 0;

if (!$stoneId) {
    echo json_encode(["status" => "error", "message" => "Invalid Request"]);
    exit();
}

// Fetch all videos related to the given `stoneId`
$sql = "SELECT sttwoId, sttwoName, videourl FROM subtittletwotbl WHERE stoneId = ?";
$stmt = $connection->prepare($sql);

if (!$stmt) {
    echo json_encode(["status" => "error", "message" => "SQL Error: " . $connection->error]);
    exit();
}

$stmt->bind_param("i", $stoneId);
$stmt->execute();
$result = $stmt->get_result();

$videos = [];

while ($row = $result->fetch_assoc()) {
    $videoId = $row['sttwoId'];
    
    // Extract YouTube video ID from URL
    preg_match('/(?:youtube\.com\/(?:[^\/]+\/.+\/|(?:v|e(?:mbed)?)\/|.*[?&]v=)|youtu\.be\/)([^"&?\/\s]{11})/i', $row['videourl'], $matches);
    $youtubeId = $matches[1] ?? null;
    $embedUrl = $youtubeId ? "https://www.youtube.com/embed/" . $youtubeId : null;
    $thumbnailUrl = $youtubeId ? "https://img.youtube.com/vi/$youtubeId/0.jpg" : null; // YouTube thumbnail

    // Check if the user has purchased access to this video
    $accessSql = "SELECT * FROM subscriptiontbl WHERE userId = ? AND videoId = ? AND exDate >= CURDATE()";
    $accessStmt = $connection->prepare($accessSql);

    if (!$accessStmt) {
        echo json_encode(["status" => "error", "message" => "Subscription SQL Error: " . $connection->error]);
        exit();
    }

    $accessStmt->bind_param("ii", $userId, $videoId);
    $accessStmt->execute();
    $accessResult = $accessStmt->get_result();

    // User has access if there is a record in `subscriptiontbl`
    $hasAccess = ($accessResult->num_rows > 0);

    // Add video data
    $videos[] = [
        "videoId" => $videoId,
        "videoTitle" => $row["sttwoName"],
        "videoUrl" => $embedUrl,
        "thumbnailUrl" => $thumbnailUrl,
        "isLocked" => !$hasAccess // True if the video is locked
    ];
}

// Return JSON response
if (empty($videos)) {
    echo json_encode(["status" => "error", "message" => "No videos available for your grade."]);
} else {
    echo json_encode(["status" => "success", "data" => $videos]);
}

// Close connection
$connection->close();
?>
