<?php
header('Content-Type: application/json');
ini_set('display_errors', 0); // hide PHP warnings from breaking JSON
error_reporting(E_ERROR | E_PARSE);

include '../includes/conn.php'; // adjust path as needed

$response = ["status" => "error", "message" => "Unknown error"];

// Check connection
if (!$connection) {
    echo json_encode(["status" => "error", "message" => "DB connection failed: " . mysqli_connect_error()]);
    exit;
}

// Only accept POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(["status" => "error", "message" => "Invalid request method"]);
    exit;
}

// Get POST data
$videoId     = $_POST['videoId']    ?? null;
$maintitle   = $_POST['maintitle']  ?? '';
$subtitle    = $_POST['subtitle']   ?? '';
$videoname   = $_POST['videoname']  ?? '';
$videolink   = $_POST['videolink']  ?? '';
$targetgrade = $_POST['Targetgrade']?? null;

if (!$videoId) {
    echo json_encode(["status" => "error", "message" => "Missing videoId"]);
    exit;
}

// Handle optional file upload
$filePath = null;
if (!empty($_FILES['files']['name'])) {
    $uploadDir = "../uploads/";
    if (!is_dir($uploadDir)) mkdir($uploadDir, 0777, true);

    $fileName = time() . "_" . basename($_FILES['files']['name']);
    $filePath = $uploadDir . $fileName;

    if (!move_uploaded_file($_FILES['files']['tmp_name'], $filePath)) {
        echo json_encode(["status" => "error", "message" => "File upload failed"]);
        exit;
    }
}

// Build SQL dynamically
$sql = "UPDATE subtittletwotbl SET maintitle=?, subtitle=?, sttwoName=?, videourl=?, videograde=?";
$params = [$maintitle, $subtitle, $videoname, $videolink, $targetgrade];
$types  = "ssssi";

if ($filePath) {
    $sql .= ", file_path=?";
    $params[] = $filePath;
    $types   .= "s";
}

$sql .= " WHERE sttwoId=?";
$params[] = $videoId;
$types   .= "i";

// Prepare and execute
$stmt = mysqli_prepare($connection, $sql);
if (!$stmt) {
    echo json_encode(["status" => "error", "message" => "Prepare failed: " . mysqli_error($connection)]);
    exit;
}

mysqli_stmt_bind_param($stmt, $types, ...$params);

if (mysqli_stmt_execute($stmt)) {
    if (mysqli_stmt_affected_rows($stmt) > 0) {
        $response = ["status" => "success", "message" => "Video updated"];
    } else {
        $response = ["status" => "error", "message" => "No changes made"];
    }
} else {
    $response = ["status" => "error", "message" => "Execution failed: " . mysqli_stmt_error($stmt)];
}

mysqli_stmt_close($stmt);
mysqli_close($connection);

echo json_encode($response);
?>