<?php
// Get the user role from the session (assuming 'jRole' holds the role value)
$userRole = isset($_SESSION['userRole']) ? $_SESSION['userRole'] : null;
?>
<style>
    :root {
        --sidebar-bg: #2c3e50; /* A deep, professional blue-gray */
        --link-color: #ecf0f1; /* Light gray for readability */
        --link-hover-bg: #34495e; /* Slightly lighter shade for hover */
        --active-link-bg: #3498db; /* A vibrant blue for active state */
        --active-link-color: #ffffff; /* White text for active link */
        --heading-color: #7f8c8d; /* Muted gray for headings */
        --footer-bg: #223140; /* Darker footer */
    }

    #layoutSidenav_nav {
        transition: width 0.3s ease;
    }

    .sb-sidenav-menu-heading {
        color: var(--heading-color) !important;
        font-size: 0.8rem;
        text-transform: uppercase;
        letter-spacing: 1px;
        padding: 1.5rem 1rem 0.5rem 1.5rem;
    }

    .sb-sidenav {
        background-color: var(--sidebar-bg) !important;
        color: var(--link-color) !important;
        border: none;
        box-shadow: 2px 0 10px rgba(0, 0, 0, 0.3);
    }

    .nav-link {
        color: var(--link-color) !important;
        transition: all 0.2s ease-in-out;
        border-left: 4px solid transparent; /* Highlight border */
        padding: 0.8rem 1.5rem;
    }

    .nav-link:hover {
        background-color: var(--link-hover-bg) !important;
        border-left-color: var(--active-link-bg);
    }

    .nav-link.active {
        background-color: var(--active-link-bg) !important;
        color: var(--active-link-color) !important;
        font-weight: bold;
        border-left-color: var(--active-link-bg);
    }

    .sb-nav-link-icon {
        color: var(--link-color);
        width: 2rem;
        text-align: center;
        transition: color 0.2s;
    }

    .nav-link:hover .sb-nav-link-icon {
        color: var(--active-link-color);
    }

    .jobrole {
        color: var(--active-link-color);
        font-weight: bold;
        text-transform: uppercase;
        text-align: center;
        letter-spacing: 1px;
        font-size: 0.9rem;
    }
    
    .sb-sidenav-footer {
        background-color: var(--footer-bg);
        border-top: 1px solid rgba(255, 255, 255, 0.1);
        padding: 1rem 1.5rem;
    }

    .sb-sidenav-footer .small {
        color: var(--heading-color);
    }
</style>
<div id="layoutSidenav_nav">
    <nav class="sb-sidenav accordion" id="sidenavAccordion">
        <div class="sb-sidenav-menu">
            <div class="nav">
                <!-- <div class="sb-sidenav-menu-heading">Core</div> -->
                <a class="nav-link active" href="admindashboard.php">
                    <div class="sb-nav-link-icon"><i class="fas fa-tachometer-alt"></i></div>
                    Dashboard
                </a>
                <!-- <div class="sb-sidenav-menu-heading">Student</div> -->
                <!-- <a class="nav-link" href="lessons.php">
                    <div class="sb-nav-link-icon"><i class="fa-solid fa-book-open"></i></div>
                    Lessons
                </a> -->
                <!-- <a class="nav-link" href="charts.html">
                    <div class="sb-nav-link-icon"><i class="fa-solid fa-user"></i></div>
                    Profile
                </a> -->

                <?php if ($userRole === 'admin'): ?>
                    <!-- <div class="sb-sidenav-menu-heading">Admin</div> -->
                    <a class="nav-link" href="charts.html">
                        <div class="sb-nav-link-icon"><i class="fas fa-users-cog"></i></div>
                        Profiles
                    </a>
                    <a class="nav-link" href="videos.php">
                        <div class="sb-nav-link-icon"><i class="fas fa-video"></i></div>
                        Videos
                    </a>
                    <a class="nav-link" href="student.php">
                        <div class="sb-nav-link-icon"><i class="fas fa-user-graduate"></i></div>
                        Students
                    </a>
                    <a class="nav-link" href="subscription.php">
                        <div class="sb-nav-link-icon"><i class="fas fa-tags"></i></div>
                        Subscription
                    </a>
                <?php endif; ?>
            </div>
        </div>
        <div class="sb-sidenav-footer">
            <div class="small">Logged in as:</div>
            <div class="jobrole"><?= $_SESSION['userRole'] ?></div>
        </div>
    </nav>
</div>