<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Student Dashboard</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <style>
        :root {
            --primary-color: #63b3ed;
            --secondary-color: #a087ff;
            --success-color: #48bb78;
            --background-light: #f7fafc;
            --card-background: #ffffff;
            --text-dark: #1a202c;
            --text-muted: #a0a0a0;
            --highlight-color: #FFC300;
        }

        body {
            font-family: 'Poppins', sans-serif;
            background-color: var(--background-light);
            color: var(--text-dark);
            margin: 0;
            padding-top: 56px;
        }

        .profile-pic {
    width: 80px;  /* Set a fixed width */
    height: 80px; /* Set a fixed height */
    object-fit: cover; /* Ensures the image covers the area without distortion */
    border: 2px solid #ccc; /* Optional: adds a slight border */
    /*
     * The 'rounded-circle' class from Bootstrap already handles border-radius: 50%;
     * If you're not using Bootstrap or the class isn't working, add:
     * border-radius: 50%;
     */
}

/* For better responsiveness on smaller screens if needed, though 80px is already small */
@media (max-width: 768px) {
    .profile-pic {
        width: 60px;
        height: 60px;
    }
}

        /* Top Navigation Bar Styles */
        .topnav-custom {
            background-color: var(--card-background);
            border-bottom: 1px solid #e0e6ed;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.05);
            transition: all 0.3s ease-in-out;
            border-bottom: 3px solid var(--highlight-color);
        }
        .topnav-brand {
            font-weight: 700;
            color: var(--text-dark);
            font-size: 1.25rem;
        }
        .topnav-greeting {
            color: var(--text-muted);
            font-weight: 500;
        }
        .topnav-greeting span {
            color: var(--text-dark);
            font-weight: 700;
        }
        .topnav-user-icon {
            color: var(--text-dark);
        }
        .topnav-dropdown-item:hover {
            background-color: #f7fafc;
        }

        /* Sidebar Styles */
        /* Sidebar Styles for a Modern Look */
.sidebar-wrapper {
    /* Use a subtle vertical gradient for depth */
    background: linear-gradient(to bottom, #1a202c, #2d3748);
    color: #e2e8f0;
    height: 100vh;
    position: fixed;
    top: 0;
    left: 0;
    width: 250px;
    transition: transform 0.4s cubic-bezier(0.25, 0.46, 0.45, 0.94); /* Smooth, modern transition */
    box-shadow: 2px 0 15px rgba(0, 0, 0, 0.4);
    z-index: 1000;
    overflow-y: auto;
    margin-top: 56px;
}

.sidebar-wrapper.collapsed {
    transform: translateX(-250px);
}

.sb-sidenav-menu {
    padding-top: 2rem; /* Add more top padding for a cleaner look */
    padding-bottom: 2rem;
}

.sidebar-menu-heading {
    color: #718096; /* A slightly softer gray for headings */
    font-size: 0.8rem;
    font-weight: 600;
    text-transform: uppercase;
    padding: 1rem 1.5rem 0.5rem;
    letter-spacing: 0.05em; /* Add slight letter spacing */
}

.sidebar-nav-link {
    color: #cbd5e0; /* A soft white color */
    padding: 1rem 1.5rem; /* Increase padding for a more spacious feel */
    display: flex; /* Use flexbox for icon and text alignment */
    align-items: center;
    text-decoration: none;
    transition: background-color 0.2s ease, transform 0.2s ease;
    border-radius: 8px; /* Add subtle rounded corners */
    margin: 0.5rem 1rem; /* Add some margin for visual separation */
}

.sidebar-nav-link:hover {
    background-color: rgba(99, 179, 237, 0.1); /* Light blue highlight on hover */
    color: var(--primary-color);
    transform: translateX(5px); /* Add a slight slide effect on hover */
}

.sidebar-nav-link.active {
    /* background-color: var(--primary-color); */
    color: white; /* White text on the active link */
    font-weight: 600;
    box-shadow: 0 4px 10px rgba(99, 179, 237, 0.3); /* Add a subtle glow */
    border-radius: 8px;
    transition: all 0.3s ease;
}

.sidebar-nav-link.active:hover {
    transform: none; /* No translation on hover for the active link */
}

.sb-nav-link-icon {
    font-size: 1.1rem; /* Slightly larger icons */
    width: 1.8rem; /* Set a fixed width for consistent alignment */
    text-align: center;
    margin-right: 1rem; /* Increase space between icon and text */
}

.sidebar-footer {
    background-color: #1a202c; /* Match the top part of the gradient */
    padding: 1.5rem 1rem;
    text-align: center;
    border-top: 1px solid rgba(255, 255, 255, 0.1);
}

.sidebar-footer .jobrole {
    font-weight: bold;
    text-transform: uppercase;
    color: var(--primary-color);
    letter-spacing: 0.05em;
    font-size: 1rem;
}

@media (max-width: 991.98px) {
    .sidebar-wrapper {
        transform: translateX(-250px);
        box-shadow: none;
    }
    .sidebar-wrapper.show {
        transform: translateX(0);
        box-shadow: 2px 0 15px rgba(0, 0, 0, 0.4);
    }
}
        /* Main Content and Dashboard Styles */
        .content-wrapper {
            margin-left: 250px;
            padding: 2rem;
            transition: margin-left 0.3s ease-in-out;
        }
        .content-wrapper.collapsed {
            margin-left: 0;
        }
        .card {
            background: var(--card-background);
            border-radius: 12px;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.05);
            transition: transform 0.3s ease, box-shadow 0.3s ease, border 0.3s ease;
            border: 1px solid transparent;
        }
        .card:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 25px rgba(0, 0, 0, 0.1), 0 0 15px rgba(99, 179, 237, 0.3);
            border-color: var(--primary-color);
        }

        /* New animated counters for stats */
        .stat-card {
            background: linear-gradient(135deg, #f0f2f5, #e0e6ed);
            border: none;
            text-align: center;
            padding: 1rem;
            border-radius: 12px;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.05);
            animation: fadeIn 0.8s ease-out;
        }
        .stat-card .fa-solid {
            font-size: 2rem;
            color: var(--primary-color);
            margin-bottom: 0.5rem;
        }
        .stat-card h5 {
            font-size: 1.5rem;
            font-weight: bold;
            color: var(--text-dark);
        }
        .stat-card p {
            color: var(--text-muted);
            margin-bottom: 0;
        }
        
        /* Video Player and Table */
        .video-player {
            border-radius: 10px;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.2);
        }
        .table-responsive {
            border-radius: 8px;
            overflow: hidden;
        }
        .list-group-item {
            background-color: transparent;
            border: none;
            padding: 0.75rem 1rem;
            border-bottom: 1px solid #e0e6ed;
            transition: background-color 0.2s ease;
        }
        .list-group-item:hover {
            background-color: #f7fafc;
        }
        
        /* Keyframe Animations */
        @keyframes pulse {
            0% { transform: scale(1); }
            50% { transform: scale(1.05); }
            100% { transform: scale(1); }
        }
        
        .new-notification {
            animation: pulse 1.5s infinite;
        }

        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }

        @media (max-width: 991.98px) {
    /* Make the sidebar hidden by default on mobile */
    .sidebar-wrapper {
        transform: translateX(-250px);
        box-shadow: none; /* No shadow when hidden */
    }
    /* The 'show' class will slide it in */
    .sidebar-wrapper.show {
        transform: translateX(0);
        box-shadow: 2px 0 10px rgba(0, 0, 0, 0.3); /* Add shadow when visible */
    }
    .content-wrapper {
        margin-left: 0; /* No margin on mobile */
    }
    .content-wrapper.sidebar-overlay {
        position: relative;
    }
    .content-wrapper.sidebar-overlay::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background-color: rgba(0, 0, 0, 0.5);
        z-index: 999;
    }
}
    </style>
</head>