<style>
    .sidebar-nav-link.active {
        background-color: #0d6efd; /* Blue background */
        color: #fff !important;
        border-radius: 8px;
    }

    .sidebar-nav-link.active i {
        color: #fff !important;
    }
</style>

<div id="layoutSidenav_nav" class="sidebar-wrapper">
    <nav class="sb-sidenav accordion" id="sidenavAccordion">
        <div class="sb-sidenav-menu">
            <div class="nav">
                <!-- Main -->
                <a class="nav-link sidebar-nav-link" href="studentdashboard.php" data-tab="dashboard">
                    <div class="sb-nav-link-icon"><i class="fas fa-tachometer-alt"></i></div>
                    Dashboard
                </a>

                <a class="nav-link sidebar-nav-link" href="#" data-tab="courses">
                    <div class="sb-nav-link-icon"><i class="fa-solid fa-person-chalkboard"></i></div>
                    Lessons
                </a>

                <a class="nav-link sidebar-nav-link" href="#" data-tab="#">
                    <div class="sb-nav-link-icon"><i class="fa-solid fa-book-open"></i></div>
                    Courses
                </a>

                <a class="nav-link sidebar-nav-link" href="#" data-tab="profile">
                    <div class="sb-nav-link-icon"><i class="fa-solid fa-user"></i></div>
                    Profile
                </a>

                <a class="nav-link sidebar-nav-link" href="#" data-tab="forum">
                    <div class="sb-nav-link-icon"><i class="fas fa-comments"></i></div>
                    Community Forum
                </a>

                <a class="nav-link sidebar-nav-link" href="#" data-tab="settings">
                    <div class="sb-nav-link-icon"><i class="fas fa-cog"></i></div>
                    Settings
                </a>

                <!-- Admin Section -->
                <?php if ($userRole === 'admin'): ?>
                    <div class="sb-sidenav-menu-heading">Admin</div>
                    <a class="nav-link sidebar-nav-link" href="charts.html">
                        <div class="sb-nav-link-icon"><i class="fas fa-users-cog"></i></div>
                        Profiles
                    </a>
                    <a class="nav-link sidebar-nav-link" href="videos.php">
                        <div class="sb-nav-link-icon"><i class="fas fa-video"></i></div>
                        Videos
                    </a>
                    <a class="nav-link sidebar-nav-link" href="student.php">
                        <div class="sb-nav-link-icon"><i class="fas fa-user-graduate"></i></div>
                        Students
                    </a>
                    <a class="nav-link sidebar-nav-link" href="subscription.php">
                        <div class="sb-nav-link-icon"><i class="fas fa-tags"></i></div>
                        Subscription
                    </a>
                <?php endif; ?>
            </div>
        </div>

        <div class="sb-sidenav-footer sidebar-footer">
            <div class="small">Logged in as:</div>
            <div class="jobrole"><?= $_SESSION['userRole'] ?></div>
        </div>
    </nav>
</div>

<!-- Main Content Area -->
<!-- <div id="mainContent" class="p-4">
    <div class="text-center text-muted">
         <button class="btn btn-outline-primary btn-sm" onclick="goBackToPreviousTab()">
                                                        <i class="fa fa-arrow-left"></i> Back
                                                    </button>
    </div>
</div> -->

<script>


document.addEventListener("DOMContentLoaded", function() {
    const navLinks = document.querySelectorAll(".sidebar-nav-link");
    const currentPage = window.location.pathname.split("/").pop();

    // Restore previously active tab
    const savedTab = localStorage.getItem("activeTab");

    navLinks.forEach(link => {
        const href = link.getAttribute("href");
        const dataTab = link.getAttribute("data-tab");

        // Highlight saved active tab or current page
        if ((href && href === currentPage) || (dataTab && dataTab === savedTab)) {
            link.classList.add("active");
        }

        link.addEventListener("click", function(e) {
            const clickedTab = this.getAttribute("data-tab");
            const clickedHref = this.getAttribute("href");

            // Remove active class from all
navLinks.forEach(l => l.classList.remove("active"));
this.classList.add("active");

// Save current and previous tabs
const previousTab = localStorage.getItem("activeTab");
if (clickedTab) {
    localStorage.setItem("previousTab", previousTab);
    localStorage.setItem("activeTab", clickedTab);
}

            // For normal PHP page links
            if (clickedHref && clickedHref !== "#") {
                if (clickedHref === currentPage) {
                    e.preventDefault();
                    location.reload(); // Refresh same page
                }
                return; // Let browser load page
            }

            // For AJAX-loaded tabs
            e.preventDefault();

            // const mainContent = document.getElementById("mainContent");
            const lastClicked = localStorage.getItem("lastClickedTab");

            // If same tab clicked again, reload content
            if (lastClicked === clickedTab) {
                refreshTabContent(clickedTab);
            } else {
                loadTabContent(clickedTab);
            }

            localStorage.setItem("lastClickedTab", clickedTab);
        });
    });

    // Load tab content (AJAX)
    function loadTabContent(tab) {
        const mainContent = document.getElementById("mainContent");
        mainContent.innerHTML = `<div class='text-center p-4'><i class='fa fa-spinner fa-spin'></i> Loading ${tab}...</div>`;

        fetch(`controller/load_${tab}.php`)
            .then(res => res.text())
            .then(html => mainContent.innerHTML = html)
            .catch(() => {
                mainContent.innerHTML = `<div class='alert alert-danger'>Failed to load ${tab}.</div>`;
            });
    }

    // Refresh tab (re-call load)
    function refreshTabContent(tab) {
        loadTabContent(tab);
    }



});
</script>
