<?php 

// Check if the user is a logged-in student
if (!isset($_SESSION['userRole']) || $_SESSION['userRole'] !== 'student') {
    header("Location: login.php");
    exit();
}
// Include database connection
include 'includes/conn.php';
// Get the user role from the session
$userRole = isset($_SESSION['jRole']) ? $_SESSION['jRole'] : null;

// Topnav greeting
date_default_timezone_set("Asia/Kolkata");
$hour = date("H");

if ($hour >= 5 && $hour < 12) {
    $greeting = "Good Morning";
} elseif ($hour >= 12 && $hour < 18) {
    $greeting = "Good Afternoon";
} else {
    $greeting = "Good Evening";
}

?>
<div>
    <nav class="sb-topnav navbar navbar-expand topnav-custom fixed-top">
        <a class="navbar-brand ps-3 topnav-brand" href="index.html">AVEnglishAcademy</a>
        <button class="btn btn-link btn-sm order-1 order-lg-0 me-4 me-lg-0" id="sidebarToggle"><i class="fas fa-bars topnav-user-icon"></i></button>
        
        <div class="d-none d-md-inline-block form-inline ms-auto me-0 me-md-3 my-2 my-md-0">
            <span class="topnav-greeting"><?= $greeting ?>, <span class="fw-bold"><?= $_SESSION['userName'] ?></span></span>
        </div>
        
        <ul class="navbar-nav ms-auto ms-md-0 me-3 me-lg-4">
            <li class="nav-item dropdown">
                <a class="nav-link dropdown-toggle" id="navbarDropdown" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false"><i class="fas fa-user-circle fa-fw topnav-user-icon"></i></a>
                <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="navbarDropdown">
                    <li><a class="dropdown-item topnav-dropdown-item" href="#!">Settings</a></li>
                    <li><a class="dropdown-item topnav-dropdown-item" href="#!">Activity Log</a></li>
                    <li><hr class="dropdown-divider" /></li>
                    <li><a class="dropdown-item topnav-dropdown-item" href="controller/logout.php">Logout</a></li>
                </ul>
            </li>
        </ul>
    </nav>
    </div>