<?php
date_default_timezone_set("Asia/Kolkata");
$hour = date("H");

if ($hour >= 5 && $hour < 12) {
    $greeting = "Good Morning";
} elseif ($hour >= 12 && $hour < 18) {
    $greeting = "Good Afternoon";
} else {
    $greeting = "Good Evening";
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Minimalist Vibrant Navbar</title>
    <!-- <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet"> -->
    <style>
        :root {
            --bg-color: #ffffff;
            --text-color: #212529;
            --brand-color: #FF5733; /* Bold vibrant orange */
            --highlight-color: #FFC300; /* Vibrant yellow for accent */
            --gray-light: #f4f5f7;
        }

        .navbar-minimalist {
            background-color: var(--bg-color);
            padding: 0rem 1rem;
            border-bottom: 3px solid var(--highlight-color); /* A subtle pop of color */
        }

        .navbar-brand-minimalist {
            color: var(--brand-color) !important;
            font-weight: 700; /* Extra bold for impact */
            font-size: 1.3rem;
            /* text-transform: uppercase; */
            letter-spacing: 1px;
            text-decoration: none;
        }
        
        .nav-link-minimalist {
            color: var(--text-color) !important;
        }
        
        .nav-link-minimalist:hover {
            color: var(--brand-color) !important;
        }

        .welcome-section-minimalist {
            display: flex;
            align-items: center;
        }

        .welcome-text-minimalist {
            margin: 0;
            font-size: 0.95rem;
            color: var(--text-color);
        }

        .user-name-minimalist {
            font-weight: 700;
            color: var(--brand-color);
            margin-left: 0.3rem;
        }

        .dropdown-item-minimalist {
            color: var(--text-color);
        }
        
        .dropdown-item-minimalist:hover {
            background-color: var(--gray-light);
        }

        .dropdown-divider-minimalist {
            background-color: #e9ecef;
        }

        .navbar-user-icon-minimalist {
            color: var(--brand-color);
            font-size: 1.5rem;
        }

        /* Responsive adjustments */
        @media (max-width: 991px) {
            .welcome-section-minimalist {
                display: none;
            }
        }
    </style>
</head>
<body>
    <nav class="navbar navbar-expand-lg navbar-minimalist">
        <div class="container-fluid">
            <a class="navbar-brand-minimalist" href="index.html">AVEnglishAcademy</a>
            <!-- <button class="btn btn-link btn-sm order-1 order-lg-0 me-4 me-lg-0" id="sidebarToggle" href="#!">
                <i class="fas fa-bars" style="color: var(--text-color);"></i>
            </button> -->

            <div class="ms-auto me-0 me-md-3 my-2 my-md-0 d-none d-md-inline-block">
                <div class="welcome-section-minimalist">
                    <p class="welcome-text-minimalist">
                        <?= $greeting ?>, <span class="user-name-minimalist"><?= $_SESSION['userName'] ?></span>
                    </p>
                </div>
            </div>

            <ul class="navbar-nav ms-auto ms-md-0">
                <li class="nav-item dropdown">
                    <a class="nav-link nav-link-minimalist dropdown-toggle" id="navbarDropdown" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                        <i class="fas fa-user-circle navbar-user-icon-minimalist"></i>
                    </a>
                    <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="navbarDropdown">
                        <li><a class="dropdown-item dropdown-item-minimalist" href="#!">Settings</a></li>
                        <li><a class="dropdown-item dropdown-item-minimalist" href="#!">Activity Log</a></li>
                        <li><hr class="dropdown-divider dropdown-divider-minimalist" /></li>
                        <li><a class="dropdown-item dropdown-item-minimalist" href="controller/logout.php">Logout</a></li>
                    </ul>
                </li>
            </ul>
        </div>
    </nav>
    <!-- <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script> -->
</body>
</html>