<?php
session_start();
// if (!isset($_SESSION['studentid'])) {
//     header("Location: login.php");
//     exit();
// }
?>
<!DOCTYPE html>
<html lang="en">
    <?php include 'includes/head.php'; ?>
    <?php include 'includes/topnav.php'; ?>

    <style>
        .dashboard-body {
            background: url('images/background/back3.jpg') no-repeat center center/cover;
            position: relative;
            padding: 20px;
        }

        .dashboard-body::before {
            content: "";
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: inherit;
            filter: blur(2px);
            z-index: -1;
        }

        .sdetails {
            font-weight: bold;
        }

        .data {
            color: #28a745;
            text-transform: uppercase;
        }

        #purchasedVideosTbl {
            text-align: center !important;
        }

        #purchasedVideosTbl th,
        #purchasedVideosTbl td {
            text-align: center !important;
            vertical-align: middle !important;
        }

        .card {
            background: rgba(255, 255, 255, 0.2);
            backdrop-filter: blur(10px);
            border-radius: 12px;
            padding: 15px;
            box-shadow: 0px 4px 10px rgba(0, 0, 0, 0.2);
            transition: all 0.3s ease-in-out;
        }

        .card:hover {
            backdrop-filter: blur(15px);
            box-shadow: 0px 6px 15px rgba(0, 0, 0, 0.3);
        }
    </style>

    <body class="dashboard-body sb-nav-fixed">
        <div id="layoutSidenav">
            <?php include 'includes/sidenav.php'; ?>

            <div id="layoutSidenav_content">
                <main>
                    <div class="container-fluid px-4">
                        <h1 class="mt-4">Dashboard</h1>
                        <ol class="breadcrumb mb-4">
                            <li class="breadcrumb-item active">Dashboard</li>
                        </ol>

                        <div class="row d-flex justify-content-center">
                            <div class="col-lg-6 col-md-6">
                                <div class="card border-warning mb-4">
                                    <div class="card-body sdetails d-flex">
                                        <div class="text-center me-3">
                                            <img id="userImage" alt="User Image" class="img-fluid rounded-circle" width="100">
                                        </div>
                                        <div class="d-flex flex-column text-start me-2 mx-3">
                                            <p>Name</p>
                                            <p>ID</p>
                                            <p>Grade</p>
                                            <p>Contact</p>
                                            <p>Join Date</p>
                                        </div>
                                        <div class="d-flex flex-column me-2">
                                            <p>:</p>
                                            <p>:</p>
                                            <p>:</p>
                                            <p>:</p>
                                            <p>:</p>
                                        </div>
                                        <div class="data d-flex flex-column justify-content-start me-2 mx-3">
                                            <p id="studentName"></p>
                                            <p id="studentId"></p>
                                            <p id="studentGrade"></p>
                                            <p id="studentContact"></p>
                                            <p id="studentjDate"></p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="card border-warning mb-4">
                            <div class="card-header bg-transparent border-warning d-flex justify-content-center align-items-center">
                                <span>
                                    <i class="fa-solid fa-cart-shopping me-1"></i> Your Purchased Videos:
                                    <span class="badge bg-success" id="videoCount">0</span>
                                </span>
                            </div>
                            <div class="card-body text-success">
                                <div class="table-responsive">
                                    <table id="purchasedVideosTbl" class="table table-hover" style="width:100%">
                                        <thead style="font-size: 13px;">
                                            <tr></tr>
                                        </thead>
                                        <tbody style="font-size: 13px;"></tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </main>
                <?php include 'includes/footer.php'; ?>
            </div>
        </div>

        <?php include 'includes/js.php'; ?>

        <script>
            $(document).ready(function () {
                loadPurchasedVideos();
            });

            fetch('controller/getuserimage.php')
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        const img = document.getElementById('userImage');
                        img.src = data.data.imageUrl;
                        img.onerror = function () {
                            this.src = 'images/default_user.png'; // Fallback
                        };
                        document.getElementById('studentName').innerText = data.data.Sfname + " " + data.data.Slname;
                        document.getElementById('studentGrade').innerText = data.data.Sgrade;
                        document.getElementById('studentContact').innerText = data.data.SContact;
                        document.getElementById('studentjDate').innerText = data.data.Sadddate;
                        document.getElementById('studentId').innerText = data.data.Sid;
                    } else {
                        console.error('Error:', data.message);
                    }
                })
                .catch(error => console.error('Error fetching student details:', error));

            function loadPurchasedVideos() {
                $.ajax({
                    type: "POST",
                    url: "controller/getpurchasedvideos.php",
                    dataType: "json",
                    success: function (data) {
                        $("#purchasedVideosTbl tbody").empty();

                        if ($("#purchasedVideosTbl thead th").length === 0) {
                            var headers = `
                                <th>No</th>
                                <th>Video ID</th>
                                <th>Video Title</th>
                                <th>Subtitle</th>
                                <th>Video Name</th>
                                <th>Purchased Date</th>
                                <th>Expiry Date</th>
                                <th>Action</th>`;
                            $("#purchasedVideosTbl thead tr").html(headers);
                        }

                        $("#videoCount").text(data.length);

                        $.each(data, function (index, row) {
                            var newRow = `
                                <tr>
                                    <td>${index + 1}</td>
                                    <td>${row.videoId}</td>
                                    <td>${row.maintitle}</td>
                                    <td>${row.subtitle}</td>
                                    <td>${row.sttwoName}</td>
                                    <td>${row.sDate}</td>
                                    <td>${row.exDate}</td>
                                    <td>
                                        <a href="${row.videourl}" target="_blank" class="btn btn-sm btn-outline-primary">Watch</a>
                                    </td>
                                </tr>`;
                            $("#purchasedVideosTbl tbody").append(newRow);
                        });

                        if (!$.fn.dataTable.isDataTable('#purchasedVideosTbl')) {
                            $('#purchasedVideosTbl').DataTable({
                                paging: true,
                                scrollY: '300px',
                                scrollX: true,
                                scrollCollapse: true,
                            });
                        } else {
                            $('#purchasedVideosTbl').DataTable().clear().rows.add($("#purchasedVideosTbl tbody tr")).draw();
                        }
                    },
                    error: function (xhr, status, error) {
                        console.error("Error loading data: ", error);
                    }
                });
            }
        </script>
    </body>
</html>
