<?php 
session_start();

// Check if user is logged in
if (!isset($_SESSION['userId'])) {
    header("Location: login.php"); // Redirect to login page
    exit();
}
?>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css" rel="stylesheet">
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.13.7/css/jquery.dataTables.min.css">
<style>
    :root {
        --primary-color: #6a0578;
        --secondary-color: #a049b4;
        --accent-color: #e5989b;
        --card-bg: rgba(255, 255, 255, 0.1);
        --text-color: #f0f2f5;
        --blur-effect: blur(10px);
        --box-shadow: 0 8px 32px 0 rgba(31, 38, 135, 0.37);
        --border: 1px solid rgba(255, 255, 255, 0.18);
    }

    body.body {
        /* background: url('images/background/back14.jpg') no-repeat center center/cover; */
        min-height: 100vh;
        color: var(--text-color);
        font-family: 'Poppins', sans-serif;
        position: relative;
        padding: 0;
    }

    .body::before {
        content: "";
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: inherit;
        filter: blur(5px);
        z-index: -1;
    }

    .glass-card {
        background: var(--card-bg);
        box-shadow: var(--box-shadow);
        backdrop-filter: var(--blur-effect);
        border: var(--border);
        border-radius: 12px;
        padding: 2.5rem;
        margin-top: 2rem;
        transition: transform 0.3s ease, box-shadow 0.3s ease;
    }

    .glass-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 16px 64px 0 rgba(31, 38, 135, 0.45);
    }

    .card-title {
        font-family: 'Montserrat', sans-serif;
        font-weight: 700;
        font-size: 2rem;
        text-align: center;
        margin-bottom: 1.5rem;
        color: var(--text-color);
    }

    .grade-badge {
        display: inline-block;
        background: linear-gradient(45deg, var(--primary-color), var(--secondary-color));
        color: white;
        padding: 0.75rem 1.5rem;
        border-radius: 50px;
        font-weight: 600;
        font-size: 1.1rem;
        box-shadow: 0 4px 15px rgba(0, 0, 0, 0.2);
        transition: all 0.3s ease-in-out;
        margin-bottom: 2rem;
    }

    .grade-badge:hover {
        transform: scale(1.05);
        box-shadow: 0 6px 20px rgba(0, 0, 0, 0.3);
    }

    .dropdown-center .btn {
        background-color: rgba(255, 255, 255, 0.15);
        color: var(--text-color);
        font-weight: 600;
        border: 1px solid rgba(255, 255, 255, 0.2);
        border-radius: 8px;
        transition: all 0.3s ease;
        padding: 1rem 1.5rem;
        font-size: 1rem;
    }

    .dropdown-center .btn:hover {
        background-color: var(--secondary-color);
        border-color: var(--secondary-color);
        transform: scale(1.02);
    }

    .dropdown-center .dropdown-menu {
        background: rgba(255, 255, 255, 0.9);
        backdrop-filter: var(--blur-effect);
        border-radius: 8px;
        border: var(--border);
        box-shadow: 0 4px 20px rgba(0, 0, 0, 0.1);
    }

    .dropdown-center .dropdown-item {
        color: #333;
        font-weight: 500;
        transition: background-color 0.2s ease;
    }

    .dropdown-center .dropdown-item:hover {
        background-color: var(--accent-color);
        color: white;
    }

    .no-lessons-message {
        color: #f8d7da;
        background-color: #721c24;
        border-radius: 8px;
        padding: 1.5rem;
        text-align: center;
        font-weight: 600;
        margin-top: 2rem;
    }
    .icon-box {
            background-color: #6c63ff;
            color: #fff;
            border-radius: 8px;
            padding: 1.5rem;
            display: inline-flex;
            justify-content: center;
            align-items: center;
        }
</style>
<body class="body sb-nav-fixed">
    <?php include 'includes/topnav.php' ?>
    <div id="layoutSidenav">
        <?php include 'includes/sidenav.php'; ?>
        <div id="layoutSidenav_content">
            <main>
                <div class="container-fluid px-4">
                    <div class="row justify-content-center">
                        <div class="col-lg-10">
                            <div class="glass-card">
                                <h5 class="card-title">Your Lessons</h5>
                                <div class="text-center mb-4">
                                    <span class="grade-badge">Grade : <span id="sgrade"><?= $_SESSION['sgrade']?></span></span>
                                </div>
                                <div id="dropdownContainer" class="row justify-content-center"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </main>
            <?php include 'includes/footer.php' ?>
        </div>
    </div>
    <script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
    <Script>
        $(document).ready(function () {
            $.ajax({
                url: "controller/getmaintittle.php",
                type: "POST",
                dataType: "json",
                success: function (response) {
                    console.log(response);
                    var dropdownContainer = $("#dropdownContainer");
                    dropdownContainer.empty();

                    if (response.status === "success" && response.data.length > 0) {
                        var hasLessons = false;
                        var rowDiv = $('<div class="row g-4 justify-content-center"></div>');

                        $.each(response.data, function (index, item) {
                            var subtitlesHtml = "";

                            if (item.subtitles.length > 0) {
                                hasLessons = true;
                                $.each(item.subtitles, function (subIndex, subtitle) {
                                    subtitlesHtml += `<li>
                                        <a class="dropdown-item" href="video.php?stoneId=${subtitle.stoneId}&stName=${encodeURIComponent(subtitle.stName)}">
                                            ${subtitle.stName}
                                        </a>
                                    </li>`;
                                });
                            } else {
                                subtitlesHtml = `<li><a class="dropdown-item" href="#">No Lessons Available</a></li>`;
                            }

                            var dropdownHTML = `
                                <div class="col-lg-3 col-md-6 col-sm-12">
                                    <div class="dropdown-center">
                                        <button class="btn btn-dark dropdown-toggle w-100" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                                            <span class="tittleId mx-2">${item.tId} - ${item.tName}</span>
                                        </button>
                                        <ul class="dropdown-menu">
                                            ${subtitlesHtml}
                                        </ul>
                                    </div>
                                </div>`;

                            rowDiv.append(dropdownHTML);
                        });

                        dropdownContainer.append(rowDiv);

                        if (!hasLessons) {
                            dropdownContainer.html("<p class='no-lessons-message'>No lessons available for your grade.</p>");
                        }
                    } else {
                        dropdownContainer.html("<p class='no-lessons-message'>No lessons available for your grade.</p>");
                    }
                },
                error: function (xhr, status, error) {
                    console.error("AJAX Error: " + xhr.responseText);
                    $("#dropdownContainer").html("<p class='no-lessons-message'>Something went wrong. Please try again.</p>");
                }
            });
        });
    </Script>
</body>
</html>