<?php
session_start();
// Include database connection
include 'includes/conn.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['submit'])) {
    $errors = [];
    $email = trim($_POST['loginEmail']);
    $password = $_POST['loginPassword'];
    $userRole = $_POST['userRole'] ?? 'student';

    if (empty($email) || empty($password)) {
        $errors[] = 'Email and Password are required.';
    } else {
        // Query the single usertbl, checking for both email and role
        $query = "SELECT * FROM usertbl WHERE Uemail = ? AND userRole = ? LIMIT 1";
        $stmt = $connection->prepare($query);

        if ($stmt) {
            $stmt->bind_param("ss", $email, $userRole);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows === 1) {
                $user = $result->fetch_assoc();

                // Check student status only if the user role is 'student'
                if ($userRole === 'student' && isset($user['uStatus']) && $user['uStatus'] == 0) {
                    $errors[] = "Your student application is not approved yet.";
                } elseif (password_verify($password, $user['Spassword'])) {
                    // Password is correct, set session variables based on role
                    $_SESSION['userRole'] = $user['userRole'];
                    $_SESSION['userId'] = $user['Uid'];
                    $_SESSION['userName'] = $user['Ufname'] . " " . $user['Ulname'];

                    if ($user['userRole'] === 'admin') {
                        // Admin-specific session data
                    } else {
                        // Student-specific session data
                        $_SESSION['userGrade'] = $user['Ugrade'];
                    }

                    // Update last login time
                    $updateQuery = "UPDATE usertbl SET UlastLogin = NOW() WHERE uId = ?";
                    $update = $connection->prepare($updateQuery);
                    $update->bind_param("i", $user['Uid']);
                    $update->execute();

                    // Check the user role from the session
                    if ($_SESSION['userRole'] === 'admin') {
                        header('Location: admindashboard.php');
                        exit();
                    } elseif ($_SESSION['userRole'] === 'student') {
                        header('Location: studentdashboard.php');
                        exit();
                    } else {
                        // A fallback for an unexpected user role
                        header('Location: index.php');
                        exit();
                    }
                } else {
                    $errors[] = "Invalid email or password.";
                }
            } else {
                $errors[] = "Invalid email or password.";
            }
        } else {
            $errors[] = "Database error: " . $connection->error;
        }
    }

    $_SESSION['login_errors'] = $errors;
    header('Location: login.php');
    exit();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Portal Login</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg, #667eea, #764ba2);
            min-height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
            font-family: 'Poppins', sans-serif;
            padding: 20px;
        }
        .auth-card {
            background: rgba(255, 255, 255, 0.15);
            backdrop-filter: blur(15px);
            border-radius: 20px;
            padding: 2rem;
            width: 100%;
            max-width: 900px;
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.2);
            animation: fadeIn 1s ease-in-out;
        }
        .auth-card h2 {
            text-align: center;
            color: #fff;
            margin-bottom: 1rem;
            font-weight: 600;
        }
        .nav-tabs {
            border-bottom: none;
            justify-content: center;
            margin-bottom: 1.5rem;
        }
        .nav-tabs .nav-link {
            color: #fff;
            border: none;
            font-weight: 500;
        }
        .nav-tabs .nav-link.active {
            background: linear-gradient(45deg, #667eea, #764ba2);
            border-radius: 10px;
            color: #fff;
            font-weight: 600;
        }
        .form-control, .form-select {
            border-radius: 10px;
            padding: 10px;
            margin-bottom: 1rem;
            border: none;
            background: rgba(255, 255, 255, 0.9);
            transition: 0.3s;
        }
        .form-control:focus, .form-select:focus {
            box-shadow: 0 0 10px rgba(102, 126, 234, 0.7);
            outline: none;
        }
        .input-group-text {
            cursor: pointer;
            background: rgba(255, 255, 255, 0.7);
            border-radius: 0 10px 10px 0;
            border: none;
        }
        button {
            background: linear-gradient(45deg, #667eea, #764ba2);
            border: none;
            border-radius: 10px;
            padding: 12px;
            width: 100%;
            color: white;
            font-weight: 600;
            transition: 0.3s;
        }
        button:hover {
            transform: scale(1.05);
            box-shadow: 0 5px 15px rgba(102, 126, 234, 0.5);
        }
        .small-text {
            text-align: center;
            margin-top: 1rem;
            color: #fff;
            font-size: 0.9rem;
        }
        .error-msg {
            color: #ffdddd;
            font-size: 0.85rem;
            margin-top: -8px;
            margin-bottom: 10px;
        }
        .strength-meter {
            height: 8px;
            border-radius: 5px;
            background: #ddd;
            margin-bottom: 10px;
        }
        .strength-meter-fill {
            height: 100%;
            border-radius: 5px;
            width: 0%;
            transition: width 0.3s;
        }
        .password-tooltip {
            background: rgba(0,0,0,0.75);
            color: #fff;
            font-size: 0.85rem;
            padding: 10px;
            border-radius: 8px;
            margin-top: -5px;
            margin-bottom: 10px;
        }
        .password-tooltip ul {
            padding-left: 20px;
            margin: 0;
        }
        .password-tooltip li {
            list-style-type: none;
            margin: 3px 0;
        }
        .valid { color: #00ff7f; }
        .invalid { color: #ff6347; }
        .role-selection {
            display: flex;
            justify-content: center;
            margin-bottom: 1.5rem;
        }
        .role-selection .btn {
            border-radius: 10px;
            font-weight: 500;
            color: #fff;
            background: rgba(255, 255, 255, 0.2);
            border: 1px solid rgba(255, 255, 255, 0.3);
            margin: 0 5px;
        }
        .role-selection .btn.active {
            background: linear-gradient(45deg, #667eea, #764ba2);
            border: none;
        }
    </style>
</head>
<body>
    <div class="auth-card">
        <h2>Portal Login</h2>
        <div class="role-selection" id="roleSelection">
            <button type="button" class="btn btn-primary active" data-role="student">Student</button>
            <button type="button" class="btn btn-primary" data-role="admin">Admin</button>
        </div>
        <ul class="nav nav-tabs" id="authTabs" role="tablist">
            <li class="nav-item">
                <a class="nav-link active" id="login-tab" data-bs-toggle="tab" href="#login" role="tab">Login</a>
            </li>
            <li class="nav-item" id="registerTab">
                <a class="nav-link" id="register-tab" data-bs-toggle="tab" href="#register" role="tab">Register</a>
            </li>
        </ul>
        <div class="tab-content">
            <div class="tab-pane fade show active" id="login" role="tabpanel">
                <?php
                if (isset($_SESSION['login_errors']) && !empty($_SESSION['login_errors'])) {
                    echo '<div class="alert alert-danger" role="alert">';
                    foreach ($_SESSION['login_errors'] as $error) {
                        echo $error . '<br>';
                    }
                    echo '</div>';
                    unset($_SESSION['login_errors']);
                }
                ?>
                <form id="loginForm" action="login.php" method="POST" novalidate>
                    <input type="hidden" id="userRole" name="userRole" value="student">
                    <input type="email" class="form-control" id="loginEmail" name="loginEmail" placeholder="Email" required>
                    <div class="input-group">
                        <input type="password" class="form-control" id="loginPassword" name="loginPassword" placeholder="Password" required>
                        <span class="input-group-text" onclick="togglePassword('loginPassword', this)">
                            <i class="fa fa-eye"></i>
                        </span>
                    </div>
                    <button type="submit" name="submit">Login</button>
                </form>
            </div>
            <div class="tab-pane fade" id="register" role="tabpanel">
                <form id="registerForm" action="controller/register.php" method="POST" enctype="multipart/form-data" novalidate>
                    <?php
// Display success or error messages from the registration process
if (isset($_SESSION['success_message']) && !empty($_SESSION['success_message'])) {
    echo '<div class="alert alert-success" role="alert">' . $_SESSION['success_message'] . '</div>';
    unset($_SESSION['success_message']); // Clear the message after displaying it
}

if (isset($_SESSION['error_message']) && !empty($_SESSION['error_message'])) {
    echo '<div class="alert alert-danger" role="alert">' . $_SESSION['error_message'] . '</div>';
    unset($_SESSION['error_message']); // Clear the message after displaying it
}
?>
                    <div class="row">
                        <div class="col-md-6"><input type="text" class="form-control" id="fname" name="inputSfname" placeholder="First Name" required></div>
                        <div class="col-md-6"><input type="text" class="form-control" id="lname" name="inputSlname" placeholder="Last Name" required></div>
                    </div>
                    <div class="row">
                        <div class="col-md-6"><input type="email" class="form-control" id="regEmail" name="logginuserName" placeholder="Email" required></div>
                        <div class="col-md-6"><input type="text" class="form-control" id="school" name="inputSschool" placeholder="School"></div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="input-group">
                                <input type="password" class="form-control" id="regPassword" name="loginuserPassword" placeholder="Password" required>
                                <span class="input-group-text" onclick="togglePassword('regPassword', this)">
                                    <i class="fa fa-eye"></i>
                                </span>
                            </div>
                            <div class="strength-meter"><div id="strengthBar" class="strength-meter-fill"></div></div>
                            <div class="password-tooltip" id="passwordTooltip">
                                <ul>
                                    <li id="reqLength" class="invalid">❌ At least 8 characters</li>
                                    <li id="reqUpper" class="invalid">❌ One uppercase letter</li>
                                    <li id="reqNumber" class="invalid">❌ One number</li>
                                    <li id="reqSpecial" class="invalid">❌ One special character (!@#$%^&*)</li>
                                </ul>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="input-group">
                                <input type="password" class="form-control" id="confirmPassword" name="confirmPassword" placeholder="Confirm Password" required>
                                <span class="input-group-text" onclick="togglePassword('confirmPassword', this)">
                                    <i class="fa fa-eye"></i>
                                </span>
                            </div>
                            <div id="confirmPasswordMsg" class="error-msg"></div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6"><input type="text" class="form-control" id="contact" name="inputScontact" placeholder="Contact No."></div>
                        <div class="col-md-6"><input type="text" class="form-control" id="whatsapp" name="inputWAno" placeholder="WhatsApp No."></div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <select class="form-select" name="inputSgender" required>
                                <option value="">Gender</option>
                                <option>Male</option><option>Female</option><option>Other</option>
                            </select>
                        </div>
                        <div class="col-md-6">
                            <select class="form-select" name="inputSgrade" required>
                                <option value="">Grade</option>
                                <option>6</option><option>7</option><option>8</option><option>9</option><option>10</option>
                            </select>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6"><input type="text" class="form-control" name="inputGname" placeholder="Guardian Name"></div>
                        <div class="col-md-6"><input type="text" class="form-control" name="inputGcontact" placeholder="Guardian Contact"></div>
                    </div>
                    <div class="row">
                        <div class="col-md-12"><input type="file" class="form-control" id="profilePic" name="inputuserSprofilepic" accept="image/*"></div>
                    </div>
                    <button type="submit" name="addnewstudentbtn">Submit Application</button>
                </form>
            </div>
        </div>
        <div class="small-text">
            <a href="../index.php">← Back to Home</a>
        </div>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        function togglePassword(fieldId, iconElement) {
            const field = document.getElementById(fieldId);
            const icon = iconElement.querySelector("i");
            if (field.type === "password") {
                field.type = "text";
                icon.classList.remove("fa-eye");
                icon.classList.add("fa-eye-slash");
            } else {
                field.type = "password";
                icon.classList.remove("fa-eye-slash");
                icon.classList.add("fa-eye");
            }
        }

        const regPassword = document.getElementById("regPassword");
        const strengthBar = document.getElementById("strengthBar");
        const reqLength = document.getElementById("reqLength");
        const reqUpper = document.getElementById("reqUpper");
        const reqNumber = document.getElementById("reqNumber");
        const reqSpecial = document.getElementById("reqSpecial");

        regPassword.addEventListener("input", function() {
            const val = regPassword.value;
            let strength = 0;
            if (val.length >= 8) { strength++; reqLength.className = "valid"; reqLength.innerText = "✅ At least 8 characters"; }
            else { reqLength.className = "invalid"; reqLength.innerText = "❌ At least 8 characters"; }
            if (/[A-Z]/.test(val)) { strength++; reqUpper.className = "valid"; reqUpper.innerText = "✅ One uppercase letter"; }
            else { reqUpper.className = "invalid"; reqUpper.innerText = "❌ One uppercase letter"; }
            if (/[0-9]/.test(val)) { strength++; reqNumber.className = "valid"; reqNumber.innerText = "✅ One number"; }
            else { reqNumber.className = "invalid"; reqNumber.innerText = "❌ One number"; }
            if (/[!@#$%^&*]/.test(val)) { strength++; reqSpecial.className = "valid"; reqSpecial.innerText = "✅ One special character (!@#$%^&*)"; }
            else { reqSpecial.className = "invalid"; reqSpecial.innerText = "❌ One special character (!@#$%^&*)"; }
            let percent = (strength / 4) * 100;
            strengthBar.style.width = percent + "%";
            if (strength <= 1) strengthBar.style.background = "red";
            else if (strength == 2) strengthBar.style.background = "orange";
            else if (strength == 3) strengthBar.style.background = "gold";
            else strengthBar.style.background = "limegreen";
        });

        const confirmPassword = document.getElementById("confirmPassword");
        const confirmPasswordMsg = document.getElementById("confirmPasswordMsg");
        function checkPasswordMatch() {
            if (confirmPassword.value === "") {
                confirmPasswordMsg.textContent = "";
                return;
            }
            if (confirmPassword.value === regPassword.value) {
                confirmPasswordMsg.textContent = "✅ Passwords match";
                confirmPasswordMsg.style.color = "limegreen";
            } else {
                confirmPasswordMsg.textContent = "❌ Passwords do not match";
                confirmPasswordMsg.style.color = "red";
            }
        }
        confirmPassword.addEventListener("input", checkPasswordMatch);
        regPassword.addEventListener("input", checkPasswordMatch);

        // Role selection and Register tab logic
        const roleButtons = document.querySelectorAll('#roleSelection .btn');
        const registerTab = document.getElementById('registerTab');
        const loginTabLink = document.getElementById('login-tab');

        roleButtons.forEach(button => {
            button.addEventListener('click', function() {
                document.querySelectorAll('#roleSelection .btn').forEach(btn => btn.classList.remove('active'));
                this.classList.add('active');
                document.getElementById('userRole').value = this.dataset.role;

                if (this.dataset.role === 'admin') {
                    // Hide the Register tab
                    registerTab.style.display = 'none';
                    // Make sure the Login tab is active
                    loginTabLink.click();
                } else {
                    // Show the Register tab
                    registerTab.style.display = 'block';
                }
            });
        });

        document.addEventListener('DOMContentLoaded', function() {
            const loginErrors = document.querySelector('.alert-danger');
            if (loginErrors) {
                const loginTab = new bootstrap.Tab(document.getElementById('login-tab'));
                loginTab.show();
            }
        });
    </script>
</body>
</html>