<?php
session_start();
// Check if the user is a logged-in student
if (!isset($_SESSION['userRole']) || $_SESSION['userRole'] !== 'student') {
    header("Location: login.php");
    exit();
}
// Include database connection
include 'includes/conn.php';
// Get the user role from the session
$userRole = isset($_SESSION['jRole']) ? $_SESSION['jRole'] : null;


?>

<!DOCTYPE html>
<html lang="en">

<?php include 'includes/studenthead.php' ?>

<body>
    <?php include 'includes/studenttopnav.php' ?>

    <div id="layoutSidenav">
        <?php include 'includes/studentsidenav.php' ?>

        <div class="content-wrapper">
            <main>
                <div class="container-fluid dashboard-container">
                    <!-- <div class="d-lg-none card p-3 text-center mb-4">
                        <img id="userImage" alt="User Image" class="img-fluid rounded-circle profile-pic mx-auto mb-3">
                        <h5 class="fw-bold mb-0"><span id="studentName"></span></h5>
                        <p class="text-muted"><span id="studentGrade"></span></p>
                    </div> -->

                    <div class="row">
                        <div class="col-lg-8">
                            <div id="dashboard-content" class="tab-content">
                                <div class="tab-pane fade show active" id="dashboard-tab-pane">
                                    <div class="row g-4 mb-4">
                                        <div class="col-md-4">
                                            <div class="card stat-card text-center">
                                                <i class="fa-solid fa-circle-check text-success"></i>
                                                <h5 class="mb-0 counter" id="completedCount">0</h5>
                                                <p class="text-muted">Videos Completed</p>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="card stat-card text-center">
                                                <i class="fa-solid fa-list-check text-primary"></i>
                                                <h5 class="mb-0 counter" id="totalCount">0</h5>
                                                <p class="text-muted">Total Videos</p>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="card stat-card text-center">
                                                <i class="fa-solid fa-hourglass-half text-warning"></i>
                                                <h5 class="mb-0" id="remainingDays">0</h5>
                                                <p class="text-muted">Days Left</p>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="card p-4 mb-4">
                                        <h4 class="fw-bold text-center mb-3">My Learning Progress</h4>
                                        <div class="row">
                                            <div class="col-md-6 d-flex justify-content-center align-items-center">
                                                <canvas id="progressChart" style="max-height: 250px;"></canvas>
                                            </div>
                                            <div class="col-md-6 d-flex align-items-center justify-content-center">
                                                <div class="text-center">
                                                    <p class="text-primary fs-5 mb-0"><i class="fa-solid fa-circle me-2"></i>You're making great progress!</p>
                                                    <p class="text-muted">Keep up the good work and stay on track with your learning goals.</p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div class="card p-4">
                                        <h4 class="fw-bold text-center mb-3">Recently Watched</h4>
                                        <div id="videoPlayerContainer" class="ratio ratio-16x9 mb-4">
                                            <div class="bg-light d-flex align-items-center justify-content-center video-placeholder">
                                                <p class="text-muted">Select a video to play</p>
                                            </div>
                                        </div>
                                        <div class="table-responsive">
                                            <table id="purchasedVideosTbl" class="table table-hover" style="width:100%">
                                                <thead>
                                                    <tr>
                                                        <th>#</th>
                                                        <th>Main Title</th>
                                                        <th>Sub Title</th>
                                                        <th>Start Date</th>
                                                        <th>Expire Date</th>
                                                        <th>Status</th>
                                                        <th>Action</th>
                                                    </tr>
                                                </thead>
                                                <tbody></tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>

                                <div class="tab-pane fade" id="courses-tab-pane">
                                    <div class="card p-4">
                                        <h4 class="fw-bold text-center mb-4">My Lessons</h4>
                                        <div id="coursesList" class="row">
                                            <div class="col-md-12 mb-4">
                                                <div class="card course-card">
                                                    <div class="card-body">
                                                        <div id="dropdownContainer" class="row justify-content-center"></div>
                                                        <!-- <h5 class="card-title fw-bold">English Grammar 101</h5>
                                                        <p class="card-text text-muted">Instructor: Jane Doe</p>
                                                        <div class="progress mb-2" style="height: 10px;">
                                                            <div class="progress-bar bg-success" role="progressbar" style="width: 75%;" aria-valuenow="75" aria-valuemin="0" aria-valuemax="100"></div>
                                                        </div>
                                                        <small class="text-muted">75% Complete</small>
                                                        <a href="#" class="btn btn-sm btn-outline-primary mt-3 d-block">Continue Course</a> -->
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- <div class="col-md-6 mb-4">
                                                <div class="card course-card">
                                                    <div class="card-body">
                                                        <h5 class="card-title fw-bold">Advanced Vocabulary</h5>
                                                        <p class="card-text text-muted">Instructor: John Smith</p>
                                                        <div class="progress mb-2" style="height: 10px;">
                                                            <div class="progress-bar bg-warning" role="progressbar" style="width: 40%;" aria-valuenow="40" aria-valuemin="0" aria-valuemax="100"></div>
                                                        </div>
                                                        <small class="text-muted">40% Complete</small>
                                                        <a href="#" class="btn btn-sm btn-outline-primary mt-3 d-block">Continue Course</a>
                                                    </div>
                                                </div>
                                            </div> -->
                                        </div>
                                    </div>
                                </div>
                                <!-- <div class="tab-pane fade" id="profile-tab-pane">
                                    <div class="card p-4">
                                        <h4 class="fw-bold text-center mb-4">Your Profile</h4>
                                        <div class="alert alert-info" role="alert">
                                            Profile information will be displayed here.
                                        </div>
                                    </div>
                                </div> -->
                                <div class="tab-pane fade" id="profile-tab-pane">
    <div class="card p-4">
        <h4 class="fw-bold text-center mb-4">Your Profile</h4>

        <!-- Alert for messages -->
        <div id="profileMessage"></div>

        <form id="studentProfileForm">
            <div class="row mb-3">
                <div class="col-md-6">
                    <label for="name" class="form-label">Full Name</label>
                    <input type="text" id="name" name="name" class="form-control" readonly>
                </div>
                <div class="col-md-6">
                    <label for="email" class="form-label">Email</label>
                    <input type="email" id="email" name="email" class="form-control" readonly>
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-md-6">
                    <label for="grade" class="form-label">Grade</label>
                    <input type="text" id="grade" name="grade" class="form-control" readonly>
                </div>
                <div class="col-md-6">
                    <label for="phone" class="form-label">Phone</label>
                    <input type="text" id="phone" name="phone" class="form-control" readonly>
                </div>
            </div>

            <div class="d-flex justify-content-end">
                <button type="button" id="editBtn" class="btn btn-primary">Edit</button>
                <button type="button" id="saveBtn" class="btn btn-success ms-2 d-none">Save</button>
                <button type="button" id="cancelBtn" class="btn btn-secondary ms-2 d-none">Cancel</button>
            </div>
        </form>
    </div>
</div>


                                <div class="tab-pane fade" id="forum-tab-pane">
                                    <div class="card p-4">
                                        <h4 class="fw-bold text-center mb-4">Community Discussion</h4>
                                        <div class="alert alert-info" role="alert">
                                            This feature is under development. Coming soon!
                                        </div>
                                    </div>
                                </div>

                                <div class="tab-pane fade" id="settings-tab-pane">
                                    <div class="card p-4">
                                        <h4 class="fw-bold text-center mb-4">Account Settings</h4>
                                        <div class="alert alert-info" role="alert">
                                            You can manage your profile, password, and notifications here.
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-4 d-none d-lg-block">
                            <div class="card p-3 text-center mb-4">
                                <img id="userImage" alt="User Image" class="img-fluid rounded-circle profile-pic mx-auto mb-3">
                                <h5 class="fw-bold mb-0">Name : <span id="studentName"></span></h5>
                                <p class="text-muted">Grade : <span id="studentGrade"></span></p>
                                <p class="text-muted">T.P : <span id="studentContact"></span></p>
                            </div>
                            <div class="card p-3">
                                <h5 class="fw-bold text-center mb-3"><i class="fas fa-bell me-2 text-warning new-notification"></i> Notifications</h5>
                                <ul class="list-group list-group-flush">
                                    <li class="list-group-item"><i class="fas fa-circle text-primary me-2" style="font-size: 8px;"></i>New video added to Science!</li>
                                    <li class="list-group-item"><i class="fas fa-circle text-success me-2" style="font-size: 8px;"></i>Your subscription is active.</li>
                                    <li class="list-group-item"><i class="fas fa-circle text-primary me-2" style="font-size: 8px;"></i>New forum topic: "Ask the Instructor"</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </main>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
    <script>

        $(document).ready(function () {
            $.ajax({
                url: "controller/getmaintittle.php",
                type: "POST",
                dataType: "json",
                success: function (response) {
                    console.log(response);
                    var dropdownContainer = $("#dropdownContainer");
                    dropdownContainer.empty();

                    if (response.status === "success" && response.data.length > 0) {
                        var hasLessons = false;
                        var rowDiv = $('<div class="row g-6 justify-content-center"></div>');

                        $.each(response.data, function (index, item) {
                            var subtitlesHtml = "";

                            if (item.subtitles.length > 0) {
                                hasLessons = true;
                                $.each(item.subtitles, function (subIndex, subtitle) {
                                    subtitlesHtml += `<li>
                                        <a class="dropdown-item" href="video.php?stoneId=${subtitle.stoneId}&stName=${encodeURIComponent(subtitle.stName)}">
                                            ${subtitle.stName}
                                        </a>
                                    </li>`;
                                });
                            } else {
                                subtitlesHtml = `<li><a class="dropdown-item" href="#">No Lessons Available</a></li>`;
                            }

                            var dropdownHTML = `
                                <div class="col-lg-4 col-md-6 col-sm-12">
                                    <div class="dropdown-center">
                                        <button class="btn btn-dark dropdown-toggle w-100 mb-2" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                                            <span class="tittleId mx-2">${item.tId} - ${item.tName}</span>
                                        </button>
                                        <ul class="dropdown-menu">
                                            ${subtitlesHtml}
                                        </ul>
                                    </div>
                                </div>`;

                            rowDiv.append(dropdownHTML);
                        });

                        dropdownContainer.append(rowDiv);

                        if (!hasLessons) {
                            dropdownContainer.html("<p class='no-lessons-message'>No lessons available for your grade.</p>");
                        }
                    } else {
                        dropdownContainer.html("<p class='no-lessons-message'>No lessons available for your grade.</p>");
                    }
                },
                error: function (xhr, status, error) {
                    console.error("AJAX Error: " + xhr.responseText);
                    $("#dropdownContainer").html("<p class='no-lessons-message'>Something went wrong. Please try again.</p>");
                }
            });
        });







       document.addEventListener('DOMContentLoaded', function() {
    const sidebarToggle = document.getElementById('sidebarToggle');
    const sidebar = document.getElementById('layoutSidenav_nav');
    const content = document.querySelector('.content-wrapper');

    // Sidebar Toggle for Desktop and Mobile
    sidebarToggle.addEventListener('click', function(event) {
        event.preventDefault();
        if (window.innerWidth < 992) {
            sidebar.classList.toggle('show');
            content.classList.toggle('sidebar-overlay');
        } else {
            sidebar.classList.toggle('collapsed');
            content.classList.toggle('collapsed');
        }
    });

    // We also need to add a click handler to the overlay to close the sidebar
    content.addEventListener('click', function() {
        if (this.classList.contains('sidebar-overlay')) {
            sidebar.classList.remove('show');
            this.classList.remove('sidebar-overlay');
        }
    });

    function setActiveLink(tabName) {
        document.querySelectorAll('.sidebar-nav-link').forEach(link => {
            link.classList.remove('active');
            if (link.getAttribute('data-tab') === tabName) {
                link.classList.add('active');
            }
        });
    }

    const navLinks = document.querySelectorAll('.sidebar-nav-link');
    const tabs = document.querySelectorAll('.tab-pane');

    // Combined click event for navigation links
    navLinks.forEach(link => {
        link.addEventListener('click', function(e) {
            e.preventDefault();
            const tabName = this.dataset.tab;

            if (tabName) {
                // 1. Switch the active tab and display the correct content
                setActiveLink(tabName);
                tabs.forEach(tab => tab.classList.remove('show', 'active'));
                const targetTab = document.getElementById(tabName + '-tab-pane');
                if (targetTab) {
                    targetTab.classList.add('show', 'active');
                }

                // 2. Load data for the selected tab if necessary
                if (tabName === 'dashboard') {
                    loadPurchasedVideos();
                }
                
                // 3. Close the sidebar on mobile after a link is clicked
                if (window.innerWidth < 992) {
                    if (sidebar.classList.contains('show')) {
                        sidebar.classList.remove('show');
                        content.classList.remove('sidebar-overlay');
                    }
                }
            }
        });
    });

    const initialTab = window.location.hash.substring(1) || 'dashboard';
    setActiveLink(initialTab);
    const initialTabPane = document.getElementById(initialTab + '-tab-pane');
    if (initialTabPane) {
        initialTabPane.classList.add('show', 'active');
    }

     fetch('controller/getuserimage.php')
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        const img = document.getElementById('userImage');
                        img.src = data.data.imageUrl;
                        img.onerror = function () {
                            this.src = 'images/default-image.jpg'; // Fallback
                        };
                        document.getElementById('studentName').innerText = data.data.Ufname + " " + data.data.Ulname;
                        document.getElementById('studentGrade').innerText = data.data.Ugrade;
                        document.getElementById('studentContact').innerText = data.data.SContact;
                        // document.getElementById('studentjDate').innerText = data.data.Sadddate;
                        // document.getElementById('studentId').innerText = data.data.Sid;
                        console.log(data.data.imageUrl);
                    } else {
                        console.error('Error:', data.message);
                    }
                })
                .catch(error => console.error('Error fetching student details:', error));


    let progressChart;
    function loadPurchasedVideos() {
        fetch('controller/getpurchasedvideos.php')
            .then(response => response.json())
            .then(data => {
                const tableBody = document.querySelector('#purchasedVideosTbl tbody');
                tableBody.innerHTML = '';
                let completedVideos = 0;
                const totalVideos = data.length;

                completedVideos = Math.floor(Math.random() * totalVideos);

                data.forEach((row, index) => {
                    const isExpired = new Date(row.exDate) < new Date();
                    const status = isExpired ? 'Expired' : 'Active';
                    const statusColor = isExpired ? 'danger' : 'success';
                    const watchBtn = isExpired ? `<button class="btn btn-sm btn-outline-secondary" disabled>Expired</button>` : `<button class="btn btn-sm btn-outline-primary watch-btn" data-url="${row.videourl}" data-title="${row.maintitle}">Watch</button>`;
                    const newRow = `
                        <tr>
                            <td>${index + 1}</td>
                            <td>${row.maintitle}</td>
                            <td>${row.subtitle}</td>
                            <td>${new Date(row.sDate).toLocaleDateString()}</td>
                            <td>${new Date(row.exDate).toLocaleDateString()}</td>
                            <td><span class="badge bg-${statusColor}">${status}</span></td>
                            <td>${watchBtn}</td>
                        </tr>
                    `;
                    tableBody.innerHTML += newRow;
                });

                document.getElementById('totalCount').innerText = totalVideos;
                document.getElementById('completedCount').innerText = completedVideos;

                if (progressChart) progressChart.destroy();
                const ctx = document.getElementById('progressChart').getContext('2d');
                progressChart = new Chart(ctx, {
                    type: 'doughnut',
                    data: {
                        labels: ['Completed', 'Pending'],
                        datasets: [{
                            data: [completedVideos, totalVideos - completedVideos],
                            backgroundColor: ['#63b3ed', '#e0e6ed'],
                            hoverOffset: 4
                        }]
                    },
                    options: {
                        responsive: true,
                        cutout: '70%',
                        animation: {
                            animateRotate: true,
                            animateScale: true
                        },
                        plugins: {
                            legend: {
                                display: false
                            }
                        }
                    }
                });

                const videoPlayerContainer = document.getElementById('videoPlayerContainer');
                document.addEventListener('click', function(e) {
                    if (e.target.classList.contains('watch-btn')) {
                        const videoUrl = e.target.dataset.url;
                        videoPlayerContainer.innerHTML = `<iframe src="${videoUrl}" frameborder="0" allowfullscreen class="embed-responsive-item video-player"></iframe>`;
                    }
                });

                if (!$.fn.DataTable.isDataTable('#purchasedVideosTbl')) {
                    $('#purchasedVideosTbl').DataTable({
                        paging: true,
                        scrollY: '300px',
                        scrollX: true,
                        scrollCollapse: true,
                        searching: true,
                        info: false,
                        destroy: true
                    });
                } else {
                    $('#purchasedVideosTbl').DataTable().clear().rows.add($(tableBody).find('tr')).draw();
                }
            });
    }
    loadPurchasedVideos();
});

$(document).ready(function() {
    const studentId = <?php echo json_encode($_SESSION['userId'] ?? ""); ?>;
    console.log(studentId);

    // Load student profile data
    function loadProfile() {
        $.ajax({
            url: "controller/getuserprofile.php",
            type: "POST",
            dataType: "json",
            data: { studentId: studentId },
            success: function(data) {
                console.log("Response:", data.user);
                if (data.success) {
                    const u = data.user;
                    $("#name").val(u.name);
                    $("#email").val(u.email);
                    $("#grade").val(u.grade);
                    $("#phone").val(u.phone);
                } else {
                    $("#profileMessage").html(`<div class='alert alert-danger'>${data.message}</div>`);
                }
            },
            error: function() {
                $("#profileMessage").html("<div class='alert alert-danger'>Error loading profile data.</div>");
            }
        });
    }

    loadProfile(); // load when tab opens or page loads

    // Enable editing
    $("#editBtn").click(function() {
        $("#studentProfileForm input").prop("readonly", false);
        $("#editBtn").addClass("d-none");
        $("#saveBtn, #cancelBtn").removeClass("d-none");
    });

    // Cancel editing
    $("#cancelBtn").click(function() {
        $("#studentProfileForm input").prop("readonly", true);
        $("#saveBtn, #cancelBtn").addClass("d-none");
        $("#editBtn").removeClass("d-none");
        loadProfile(); // reload original data
    });

    // Save changes
    $("#saveBtn").click(function() {
        const formData = {
            studentId: studentId,
            name: $("#name").val(),
            email: $("#email").val(),
            grade: $("#grade").val(),
            phone: $("#phone").val()
        };

        $.ajax({
            url: "controller/updatestudentprofile.php",
            type: "POST",
            dataType: "json",
            data: formData,
            success: function(response) {
                if (response.success) {
                    $("#profileMessage").html(`<div class='alert alert-success'>${response.message}</div>`);
                    $("#studentProfileForm input").prop("readonly", true);
                    $("#saveBtn, #cancelBtn").addClass("d-none");
                    $("#editBtn").removeClass("d-none");
                } else {
                    $("#profileMessage").html(`<div class='alert alert-danger'>${response.message}</div>`);
                }
            },
            error: function() {
                $("#profileMessage").html("<div class='alert alert-danger'>Failed to save changes.</div>");
            }
        });
    });
});


    </script>
</body>
</html>