<?php 
session_start();

// Check if user is logged in
if (!isset($_SESSION['userId'])) {
    header("Location: login.php"); // Redirect to login page
    exit();
}
?>
<style>
    btn-outline-primary {
    border-radius: 6px;
    font-size: 0.9rem;
    padding: 4px 10px;
}
.tab-header h4 {
    margin: 0;
}
</style>
<?php include 'includes/studenthead.php' ?>
    
    <body class="body sb-nav-fixed">
        <?php include 'includes/studenttopnav.php' ?>
        <div id="layoutSidenav">
            <?php include 'includes/studentsidenav.php' ?>
            <div class="content-wrapper">
                <main>
                    <div class="container-fluid dashboard-container">
                        <div class="row">
                            <div class="col-12 grid-margin stretch-card">
                                <div class="card border-warning mt-2">
                                    <div class="row">
                                        <div class="col-lg-12 col-md-12">
                                            <div class="card-body">
                                                <div class="tab-header d-flex justify-content-between align-items-center mb-3">
                                                    <h4 class="fw-bold">Lessons</h4>
                                                </div>
                                                <h4 class="card-title text-center">Videos</h4> 
                                                <h5 class="lesson mb-3">Lesson : <span id="lessonname"></span></h5> 
                                                <div class="row" id="videoContainer">
                                                    <!-- Videos will be dynamically added here -->
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- Bootstrap Modal for Subscription Info -->
                        <div class="modal fade" id="subscribeModal" tabindex="-1" data-bs-backdrop="static" aria-labelledby="subscribeModalLabel" aria-hidden="true">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title" id="subscribeModalLabel">How to Subscribe?</h5>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                    </div>
                                    <div class="modal-body">
                                        <p>To unlock this video, you need to subscribe this Video. Follow these steps:</p>
                                        <ul>
                                            <li>Please Contact your Class Teacher from this 071 12 34 567 number.</li>
                                            <li>Follow the Instructions.</li>
                                            <!-- <li>Go to the subscription page.</li>
                                            <li>Choose a plan that suits you.</li>
                                            <li>Complete the payment.</li>
                                            <li>Enjoy unlimited access to our videos!</li> -->
                                        </ul>
                                    </div>
                                    <div class="modal-footer">
                                        <!-- <a href="subscribe.php" class="btn btn-primary">Go to Subscription</a> -->
                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </main>
                <?php include 'includes/footer.php' ?>
            </div>
        </div>
        <?php include 'includes/js.php' ?>

    <Script>
       $(document).ready(function () {
    function getUrlParameter(name) {
        var urlParams = new URLSearchParams(window.location.search);
        return urlParams.get(name);
    }

    var stoneId = getUrlParameter("stoneId");
    var stName = getUrlParameter("stName");

    if (!stoneId || !stName) {
        $("#videoContainer").html("<p class='text-danger text-center'>Invalid Request: Missing stoneId.</p>");
        return;
    }

    $.ajax({
        url: "controller/getvideos.php",
        type: "GET",
        data: { stoneId: stoneId },
        dataType: "json",
        success: function (response) {
            console.log(response);
            var videoContainer = $("#videoContainer");
            videoContainer.empty();

            $("#lessonname").text(stName);

            if (response.status === "success" && response.data.length > 0) {
                $.each(response.data, function (index, videos) {
                    var videoHTML;

                    if (videos.isLocked) {
    // Locked Video
    videoHTML = `
        <div class="col-lg-3 col-md-4 col-sm-6 mb-4">
            <div class="card">
                <div class="card-body text-center">
                    <h5 class="card-title">${videos.videoTitle}</h5>
                    <div class="ratio ratio-16x9 position-relative" style="background-color: black; border-radius: 10px; overflow: hidden;">
                        <!-- Blurred Video -->
                        <div class="video-wrapper locked">
                            <iframe 
                                src="https://www.youtube.com/embed/${videos.videoUrl}?modestbranding=1&rel=0&controls=0"
                                style="filter: blur(6px); pointer-events: none; opacity: 0.5;" 
                                allowfullscreen>
                            </iframe>
                        </div>
                        <!-- Locked Overlay -->
                        <div class="position-absolute top-50 start-50 translate-middle text-center">
                            <img src="images/auth/locked.png" class="img-fluid mb-2" 
                                style="width: 50px; opacity: 0.9;" 
                                alt="Locked">
                            <p class="text-white fw-bold mb-2" style="font-size: 14px;">This video is locked.</p>
                            <button class="btn btn-primary btn-sm subscribe-btn" data-video-id="${videos.videoId}">Subscribe Now</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>`;
} else {
    // ✅ Unlocked Video with Domain Protection
    videoHTML = `
        <div class="col-lg-3 col-md-4 col-sm-6 mb-4">
            <div class="card">
                <div class="card-body text-center">
                    <h5 class="card-title">${videos.videoTitle}</h5>
                    <div class="ratio ratio-16x9 position-relative video-secure-wrapper" 
                         data-video-id="${videos.videoUrl}">
                        <div class="video-placeholder text-center text-white d-flex align-items-center justify-content-center"
                             style="background:#000;cursor:pointer;height:100%;border-radius:10px;">
                            <p class="m-0">▶ Click to Play</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>`;
}

                    videoContainer.append(videoHTML);
                });

                // Event listener for subscribe button
                $(".subscribe-btn").click(function () {
                    var videoId = $(this).data("video-id");
                    $("#subscribeModal").modal("show"); // Show modal
                    $("#subscribeNowBtn").attr("href", "subscribe.php?videoId=" + videoId); // Update the link dynamically
                });

            } else {
                videoContainer.html("<p class='text-center'>No videos found.</p>");
            }
        },
        error: function (xhr, status, error) {
            console.error("AJAX Error: " + xhr.responseText);
        }
    });
});

function removeOverlay() {
    // Hide overlay after click
    document.getElementById("video-overlay").style.display = "none";

    // Allow autoplay after removing overlay
    var iframe = document.getElementById("youtube-iframe");
    iframe.src = iframe.src + "&autoplay=1"; // Start the video
}

// Handle secure playback
$(document).on("click", ".video-placeholder", function () {
    const wrapper = $(this).closest(".video-secure-wrapper");
    const videoId = wrapper.data("video-id");
    const domain = window.location.hostname;

    // ✅ Check if domain is authorized (replace with your LMS domain)
    const allowedDomain = "avenglish.com"; // <-- change this
    if (domain !== allowedDomain) {
        wrapper.html("<div class='text-danger text-center'>Access Denied ❌</div>");
        return;
    }
//     const allowedDomains = ["localhost", "127.0.0.1", "yourdomain.com"]; 
// const domain = window.location.hostname;

// if (!allowedDomains.includes(domain)) {
//     wrapper.html("<div class='text-danger text-center'>Access Denied ❌</div>");
//     return;
// }

    // ✅ Create iframe dynamically only after click (so URL never shows in source before play)
    const iframe = `
        <iframe 
            src="https://www.youtube.com/embed/${videoId}?autoplay=1&modestbranding=1&rel=0&controls=1&disablekb=1"
            frameborder="0" 
            allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"
            allowfullscreen 
            style="width:100%;height:100%;border-radius:10px;">
        </iframe>
    `;

    wrapper.html(iframe);
});

// Disable right-click
document.addEventListener("contextmenu", event => event.preventDefault());

document.addEventListener("DOMContentLoaded", function() {
    // If user comes here from Lessons tab, store the return path
    const lastTab = localStorage.getItem("activeTab");

    window.addEventListener("popstate", function () {
        if (lastTab === "courses") {
            // Go back to main dashboard page, with ?tab=courses
            window.location.href = "studentdashboard.php?tab=courses";
        }
    });
});

        </Script>

    </body>
</html>
