<?php 
session_start();

// Check if user is logged in
if (!isset($_SESSION['studentid'])) {
    header("Location: login.php"); // Redirect to login page
    exit();
}
?>
<?php session_start(); ?>
<?php include 'includes/head.php' ?>
    <body class="sb-nav-fixed">
    <style>
        .ui-autocomplete {
            z-index: 1051 !important; /* Ensure it is above Bootstrap modal (which is 1050) */
            position: absolute; /* Required for correct positioning */
            background: white; /* Ensure visibility */
            border: 1px solid #ccc;
            max-height: 200px;
            overflow-y: auto;
        }
  </style>
        <?php include 'includes/topnav.php' ?>
        <div id="layoutSidenav">
            <?php include 'includes/sidenav.php' ?>
            <div id="layoutSidenav_content">
                <main>
                    <div class="row mx-2">
                        <div class="col-12 grid-margin stretch-card">
                            <div class="card mt-2">
                                <div class="row mt-3">
                                    <div class="col-lg-12 col-md-12">
                                        <div class="card-body">
                                            <h5 class="card-title">Add Videos</h5>
                                            <h6 class="#">Grade : <span id="sgrade"><?= $_SESSION['sgrade']?></span></h6>
                                            <div class="row">
                                                <div class="col-lg-12 d-flex justify-content-center">
                                                    <div class="mx-1">
                                                        <button type="button" class="btn btn-sm btn-success mb-3" data-bs-toggle="modal" data-bs-target="#addnewtitlemodal">
                                                            <i class="fa-solid fa-plus mx-2"></i>Add New Title
                                                        </button>
                                                        <button type="button" class="btn btn-sm btn-secondary mb-3" data-bs-toggle="collapse" data-bs-target="#collapseaddsubtitle">
                                                            <i class="fa-solid fa-plus mx-2"></i>Add Sub Title
                                                        </button>
                                                        <button type="button" class="btn btn-sm btn-warning mb-3" data-bs-toggle="collapse" data-bs-target="#collapseAddvideo">
                                                            <i class="fa-solid fa-plus mx-2"></i>add New Video
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div id="successMessage" class="alert alert-success text-center" style="display: none;"></div>
                                    <!-- Modal -->
                                    <div class="modal fade" id="addnewtitlemodal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
                                        <div class="modal-dialog">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h1 class="modal-title fs-5" id="staticBackdropLabel">Add Main Title</h1>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    <div class="row d-flex justify-content-center">
                                                        <div class="col-lg-6">
                                                            <div class="input-group-sm mb-2">
                                                                <label for="grade" class="form-label mb-2">Title Name</label>
                                                                <input class="form-control form-control-sm" id="titleName" type="text" placeholder="Add Main Title Here" aria-label=".form-control-sm example">
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-6">
                                                            <label for="grade" class="form-label mb-2">Target Grade</label>
                                                            <select class="form-select form-select-sm" id="inputTargetgrade" name="inputTargetgrade">
                                                                <option value="6">6</option>
                                                                <option value="7">7</option>
                                                                <option value="8">8</option>
                                                                <option value="9">9</option>
                                                                <option value="10">10</option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                    <div class="row">
                                                        <div class="d-flex justify-content-center">
                                                            <button type="button" id="addtitlebtn" class="btn btn-sm btn-outline-success">Add Title</button>
                                                        </div>
                                                    </div>
                                                </div>
                                                <!-- <div class="modal-footer">
                                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                                <button type="button" class="btn btn-primary">Understood</button>
                                                </div> -->
                                            </div>
                                        </div>
                                    </div>
                                    <div class="collapse mb-2" id="collapseaddsubtitle">
                                        <div class="row">
                                            <div class="d-flex justify-content-center">
                                                <div class="col-lg-6">
                                                    <div class="card card-body">
                                                        <div class="row justify-content-center">
                                                            <div class="col-lg-6">
                                                                <div class="input-group-sm mb-2">
                                                                    <input class="form-control form-control-sm" type="text" id="maintitle" name="maintitle" placeholder="Add Main Title Here" aria-label=".form-control-sm example">
                                                                </div>
                                                            </div>
                                                            <div class="col-lg-6">
                                                                <div class="input-group-sm mb-2">
                                                                    <input class="form-control form-control-sm" type="text" id="inputsubtitle" name="inputsubtitle" placeholder="Add Sub Title Here" aria-label=".form-control-sm example">
                                                                </div>
                                                            </div>
                                                            <div class="col-lg-12 d-flex justify-content-center">
                                                                <button type="button" id="addsubtitlebtn" class="btn btn-sm btn-outline-primary">Add Sub Title</button>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- start add user collapse -->
                                    <div class="collapse" id="collapseAddvideo">
                                        <div class="container">
                                        <div class="card card-body p-3 mb-5 rounded">
                                            <form action="controller/addnewvideo.php" method="POST" enctype="multipart/form-data">
                                            <div class="row">
                                                <div class="col-lg-4">
                                                    <div class="input-group-sm mb-2">
                                                        <label for="inputVideotittle" class="form-label">Main Tittle</label>
                                                        <input type="text" class="form-control" id="inputVideotittle" name="inputVideotittle" placeholder="Video Main Tittle">
                                                    </div>
                                                </div>
                                                <div class="col-lg-3">
                                                    <div class="input-group-sm mb-2">
                                                        <label for="inputVideoStittle" class="form-label">Sub Tittle</label>
                                                        <input type="text" class="form-control" id="inputVideoStittle" name="inputVideoStittle" placeholder="Video Sub Tittle">
                                                    </div>
                                                </div>
                                                <div class="col-lg-1">
                                                    <div class="input-group-sm mb-2">
                                                        <input type="hidden" class="form-control" id="inputVideoSId" name="inputVideoSId">
                                                    </div>
                                                </div>
                                                <div class="col-lg-4">
                                                    <div class="input-group-sm mb-2">
                                                        <label for="inputVideoname" class="form-label">Video Name</label>
                                                        <input type="text" class="form-control" id="inputVideoname" name="inputVideoname" placeholder="Video Name">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row mt-3">
                                                <div class="col-lg-4">
                                                <div class="input-group-sm mb-2">
                                                    <label for="inputVideolink" class="form-label">Link</label>
                                                    <input type="text" class="form-control" id="inputVideolink" name="inputVideolink" placeholder="Your Video Link">
                                                </div>
                                                </div>
                                                <!-- <div class="col-lg-4">
                                                <div class="input-group-sm mb-2">
                                                    <label for="userContact" class="form-label">Target grade</label>
                                                    <input type="text" class="form-control" id="userContact" name="userContact" placeholder="Contact">
                                                </div>
                                                </div> -->
                                                <div class="col-lg-4">
                                                <label for="grade" class="form-label mb-2">Target Grade</label>
                                                <select class="form-select form-select-sm" id="inputTargetgrade" name="inputTargetgrade">
                                                    <option value="6">6</option>
                                                    <option value="7">7</option>
                                                    <option value="8">8</option>
                                                    <option value="9">9</option>
                                                    <option value="10">10</option>
                                                </select>
                                                </div>
                                            </div>
                                            <div class="row mt-3">
                                                <div class="col-lg-4">
                                                <div class="input-group-sm mb-2">
                                                    <label for="excersice" class="form-label">Excersice related to the video</label>
                                                    <input type="file" class="form-control" id="excersice" name="excersice" placeholder="Activity">
                                                </div>
                                                </div>
                                            <div class="row mt-3">
                                                <div class="d-flex justify-content-end">
                                                <button type="submit" class="btn btn-sm btn-outline-success mb-3" name="addnewvideobtn"><i class="fa-solid fa-floppy-disk mx-2"></i>Upload
                                                </button>
                                                </div>
                                            </div>
                                            </form>
                                        </div>
                                        </div>
                                    </div>
                                    <!-- end add new item collapse -->
                                </div>
                            </div>
                        </div>
                    </div>
                </main>
                <?php include 'includes/footer.php' ?>
            </div>
        </div>
        <?php include 'includes/js.php' ?>

        <Script>
            $(document).ready(function () {

                let selectedMainTitleId = null; // Store the selected title ID
                let selectedTitleId = null; // Store the selected title ID

                $("#maintitle").autocomplete({
                    source: function (request, response) {
                        $.ajax({
                            url: "controller/gettitles.php",
                            dataType: "json",
                            data: { term: request.term },
                            success: function (data) {
                                console.log("Received Data:", data); // Debugging output

                                if (Array.isArray(data) && data.length > 0) {
                                    response(
                                        data.map(item => ({
                                            label: item.label, // Display in autocomplete dropdown
                                            value: item.value, // Set in input field
                                            id: item.id // Store the ID
                                        }))
                                    );
                                } else {
                                    console.log("No suggestions found.");
                                    response([]); // No results
                                }
                            },
                            error: function (xhr, status, error) {
                                console.log("AJAX Error:", error);
                            }
                        });
                    },
                    minLength: 1,
                    appendTo: "body",
                    select: function (event, ui) {
                        console.log("Selected Title:", ui.item.value, "ID:", ui.item.id);
                        $("#maintitle").val(ui.item.value); // Ensure input field updates
                        selectedMainTitleId = ui.item.id; // ✅ Store the selected title ID
                        console.log("Stored ID:", selectedMainTitleId); // Debugging
                        return false; // Prevent default behavior
                    }
                });

                $("#inputVideotittle").autocomplete({
                    source: function(request, response) {
                        $.ajax({
                            url: "controller/gettitles.php",
                            dataType: "json",
                            data: { term: request.term },
                            success: function(data) {
                                console.log("Received Data:", data); // Debugging output
                                
                                if (Array.isArray(data) && data.length > 0) {
                                    response(data.map(item => ({
                                        label: item.label, // Display in autocomplete list
                                        value: item.value, // Set in input field
                                        id: item.id // Store for later use
                                    })));
                                } else {
                                    console.log("No suggestions found.");
                                    response([]);
                                }
                            },
                            error: function(xhr, status, error) {
                                console.log("AJAX Error:", error);
                            }
                        });
                    },
                    minLength: 1,
                    appendTo: "body",
                    select: function(event, ui) {
                        console.log("Selected:", ui.item.value, "ID:", ui.item.id);
                        $("#inputVideotittle").val(ui.item.value);
                        selectedTitleId = ui.item.id;
                        console.log(ui.item.id); // Debug
                        return false;
                    }
                });



                $("#inputVideoStittle").autocomplete({
                    source: function(request, response) {
                        $.ajax({
                            url: "controller/getstitles.php",  // Your backend script
                            dataType: "json",
                            data: {
                                term: request.term,              // The search term entered by the user
                                titleId: selectedTitleId         // The selected title ID, to filter results
                            },
                            success: function(data) {
                                console.log("Received Data:", data); // Debugging output

                                if (Array.isArray(data) && data.length > 0) {
                                    response(data); // Return the filtered data
                                } else {
                                    console.log("No suggestions found.");
                                    response([]); // No results
                                }
                            },
                            error: function(xhr, status, error) {
                                console.error("AJAX Error:", status, error);
                                console.log("Response Text:", xhr.responseText); // Show server response
                            }
                        });
                    },
                    minLength: 1,
                    appendTo: "body", // Ensures autocomplete appears above modal
                    select: function(event, ui) {
                        console.log("Selected:", ui.item.value, "ID:", ui.item.id);
                        $("#inputVideoStittle").val(ui.item.value); // Ensure the input field updates
                        $("#inputVideoSId").val(ui.item.id); // Store the selected subtitle ID (if needed)
                        return false; // Prevent default behavior
                    }
                });





                $("#addtitlebtn").click(function () {
                    let titleName = $("#titleName").val().trim();
                    let targetGrade = $("#inputTargetgrade").val();

                    if (titleName === "") {
                        Swal.fire({
                            icon: "warning",
                            title: "Oops!",
                            text: "Please enter a title name.",
                            confirmButtonColor: "#3085d6",
                        });
                        return;
                    }

                    $.ajax({
                        url: "controller/addnewtitle.php", // PHP script to handle the request
                        type: "POST",
                        data: { titleName: titleName, targetGrade: targetGrade },
                        dataType: "json",
                        success: function (response) {
                            if (response.success) {
                                // Show SweetAlert success message
                                Swal.fire({
                                    icon: "success",
                                    title: "Success!",
                                    text: "Title has been successfully added.",
                                    showConfirmButton: false,
                                    timer: 2000, // Auto close after 2 seconds
                                });

                                // Clear input fields
                                $("#titleName").val("");
                                $("#inputTargetgrade").val("6");

                                // Close modal after 2 seconds
                                setTimeout(function () {
                                    $("#addnewtitlemodal").modal("hide");
                                    $("#successMessage").hide(); // Hide message after closing
                                }, 2000);
                            } else {
                                alert("Error: " + response.error);
                            }
                        },
                        error: function (xhr, status, error) {
                            console.error("AJAX Error:", status, error);
                        }
                    });
                });

                $("#addsubtitlebtn").click(function () {
                    let subtitle = $("#inputsubtitle").val().trim(); // Get subtitle text

                    if (!selectedMainTitleId) {
                        Swal.fire({
                            icon: "warning",
                            title: "Oops!",
                            text: "Please select a main title first.",
                            confirmButtonColor: "#3085d6",
                        });
                        return;
                    }

                    if (subtitle === "") {
                        Swal.fire({
                            icon: "warning",
                            title: "Oops!",
                            text: "Please enter a subtitle.",
                            confirmButtonColor: "#3085d6",
                        });
                        return;
                    }

                    $.ajax({
                        url: "controller/addnewstitle.php", // Your backend script
                        type: "POST",
                        data: {
                            videoTitleId: selectedMainTitleId, // Send the selected title ID
                            subtitle: subtitle
                        },
                        dataType: "json",
                        success: function (response) {
                            if (response.success) {
                                Swal.fire({
                                    icon: "success",
                                    title: "Success!",
                                    text: "Subtitle has been added successfully.",
                                    showConfirmButton: false,
                                    timer: 2000,
                                });

                                $("#maintitle").val("");  // Clear main title field
                                $("#inputsubtitle").val(""); // Clear subtitle field

                                selectedMainTitleId = null;
                            } else {
                                Swal.fire({
                                    icon: "error",
                                    title: "Error!",
                                    text: response.error,
                                    confirmButtonColor: "#d33",
                                });
                            }
                        },
                        error: function (xhr, status, error) {
                            console.error("AJAX Error:", status, error);
                            Swal.fire({
                                icon: "error",
                                title: "AJAX Error!",
                                text: "Something went wrong. Please try again.",
                                confirmButtonColor: "#d33",
                            });
                        }
                    });
                });

            });



        </Script>

    </body>
</html>
