<?php session_start(); ?>
<?php include 'includes/head.php' ?>
    <body class="sb-nav-fixed">
    <style>
        .ui-autocomplete {
            z-index: 1100 !important; /* Ensure it is above Bootstrap modal (which is 1050) */
            position: absolute; /* Required for correct positioning */
            background: white; /* Ensure visibility */
            border: 1px solid #ccc;
            max-height: 200px;
            overflow-y: auto;
        }
        #videosDatatbl th,
        #videosDatatbl td {
            text-align: center !important;
            vertical-align: middle !important;
        }
  </style>
        <?php include 'includes/topnav.php' ?>
        <div id="layoutSidenav">
            <?php include 'includes/sidenav.php' ?>
            <div id="layoutSidenav_content">
                <main>
                    <div class="row mx-2">
                        <div class="col-12 grid-margin stretch-card">
                            <div class="card mt-2">
                                <div class="row mt-3">
                                    <div class="col-lg-12 col-md-12">
                                        <div class="card-body">
                                            <h5 class="card-title">Add Videos</h5>
                                            <!-- <h6 class="#">Grade : <span id="sgrade"><?= $_SESSION['sgrade']?></span></h6> -->
                                            <div class="row">
                                                <div class="col-lg-12 d-flex justify-content-center">
                                                    <div class="mx-1">
                                                        <button type="button" class="btn btn-sm btn-success mb-3" data-bs-toggle="modal" data-bs-target="#addnewtitlemodal">
                                                            <i class="fa-solid fa-plus mx-2"></i>Add New Title
                                                        </button>
                                                        <button type="button" class="btn btn-sm btn-secondary mb-3" data-bs-toggle="collapse" data-bs-target="#collapseaddsubtitle">
                                                            <i class="fa-solid fa-plus mx-2"></i>Add Sub Title
                                                        </button>
                                                        <button type="button" class="btn btn-sm btn-warning mb-3" data-bs-toggle="collapse" data-bs-target="#collapseAddvideo">
                                                            <i class="fa-solid fa-plus mx-2"></i>add New Video
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div id="successMessage" class="alert alert-success text-center" style="display: none;"></div>
                                    <!-- Modal -->
                                    <div class="modal fade" id="addnewtitlemodal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
                                        <div class="modal-dialog">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h1 class="modal-title fs-5" id="staticBackdropLabel">Add Main Title</h1>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    <div class="row d-flex justify-content-center">
                                                        <div class="col-lg-6">
                                                            <div class="input-group-sm mb-2">
                                                                <label for="grade" class="form-label mb-2">Title Name</label>
                                                                <input class="form-control form-control-sm" id="titleName" type="text" placeholder="Add Main Title Here" aria-label=".form-control-sm example">
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-6">
                                                            <label for="grade" class="form-label mb-2">Target Grade</label>
                                                            <select class="form-select form-select-sm" id="inputTargetgrade" name="inputTargetgrade">
                                                                <option value="6">6</option>
                                                                <option value="7">7</option>
                                                                <option value="8">8</option>
                                                                <option value="9">9</option>
                                                                <option value="10">10</option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                    <div class="row">
                                                        <div class="d-flex justify-content-center">
                                                            <button type="button" id="addtitlebtn" class="btn btn-sm btn-outline-success">Add Title</button>
                                                        </div>
                                                    </div>
                                                </div>
                                                <!-- <div class="modal-footer">
                                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                                <button type="button" class="btn btn-primary">Understood</button>
                                                </div> -->
                                            </div>
                                        </div>
                                    </div>
                                    <div class="collapse mb-2" id="collapseaddsubtitle">
                                        <div class="row">
                                            <div class="d-flex justify-content-center">
                                                <div class="col-lg-6">
                                                    <div class="card card-body">
                                                        <div class="row justify-content-center">
                                                            <div class="col-lg-6">
                                                                <div class="input-group-sm mb-2">
                                                                    <input class="form-control form-control-sm" type="text" id="maintitle" name="maintitle" placeholder="Add Main Title Here" aria-label=".form-control-sm example">
                                                                </div>
                                                            </div>
                                                            <div class="col-lg-6">
                                                                <div class="input-group-sm mb-2">
                                                                    <input class="form-control form-control-sm" type="text" id="inputsubtitle" name="inputsubtitle" placeholder="Add Sub Title Here" aria-label=".form-control-sm example">
                                                                </div>
                                                            </div>
                                                            <div class="col-lg-12 d-flex justify-content-center">
                                                                <button type="button" id="addsubtitlebtn" class="btn btn-sm btn-outline-primary">Add Sub Title</button>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- start add user collapse -->
                                    <div class="collapse" id="collapseAddvideo">
                                        <div class="container">
                                        <div class="card card-body p-3 mb-5 rounded">
                                            <form action="controller/addnewvideo.php" method="POST" enctype="multipart/form-data">
                                            <div class="row">
                                                <div class="col-lg-4">
                                                    <div class="input-group-sm mb-2">
                                                        <label for="inputVideotittle" class="form-label">Main Tittle</label>
                                                        <input type="text" class="form-control" id="inputVideotittle" name="inputVideotittle" placeholder="Video Main Tittle">
                                                    </div>
                                                </div>
                                                <div class="col-lg-3">
                                                    <div class="input-group-sm mb-2">
                                                        <label for="inputVideoStittle" class="form-label">Sub Tittle</label>
                                                        <input type="text" class="form-control" id="inputVideoStittle" name="inputVideoStittle" placeholder="Video Sub Tittle">
                                                    </div>
                                                </div>
                                                <div class="col-lg-1">
                                                    <div class="input-group-sm mb-2">
                                                        <input type="hidden" class="form-control" id="inputVideoSId" name="inputVideoSId">
                                                    </div>
                                                </div>
                                                <div class="col-lg-4">
                                                    <div class="input-group-sm mb-2">
                                                        <label for="inputVideoname" class="form-label">Video Name</label>
                                                        <input type="text" class="form-control" id="inputVideoname" name="inputVideoname" placeholder="Video Name">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row mt-3">
                                                <div class="col-lg-4">
                                                <div class="input-group-sm mb-2">
                                                    <label for="inputVideolink" class="form-label">Link</label>
                                                    <input type="text" class="form-control" id="inputVideolink" name="inputVideolink" placeholder="Your Video Link">
                                                </div>
                                                </div>
                                                <!-- <div class="col-lg-4">
                                                <div class="input-group-sm mb-2">
                                                    <label for="userContact" class="form-label">Target grade</label>
                                                    <input type="text" class="form-control" id="userContact" name="userContact" placeholder="Contact">
                                                </div>
                                                </div> -->
                                                <div class="col-lg-4">
                                                <label for="grade" class="form-label mb-2">Target Grade</label>
                                                <select class="form-select form-select-sm" id="inputTargetgrade" name="inputTargetgrade">
                                                    <option value="6">6</option>
                                                    <option value="7">7</option>
                                                    <option value="8">8</option>
                                                    <option value="9">9</option>
                                                    <option value="10">10</option>
                                                </select>
                                                </div>
                                            </div>
                                            <div class="row mt-3">
                                                <div class="col-lg-4">
                                                <div class="input-group-sm mb-2">
                                                    <label for="excersice" class="form-label">Excersice related to the video</label>
                                                    <input type="file" class="form-control" id="excersice" name="excersice" placeholder="Activity">
                                                </div>
                                                </div>
                                            <div class="row mt-3">
                                                <div class="d-flex justify-content-end">
                                                <button type="submit" class="btn btn-sm btn-outline-success mb-3" name="addnewvideobtn"><i class="fa-solid fa-floppy-disk mx-2"></i>Upload
                                                </button>
                                                </div>
                                            </div>
                                            </form>
                                        </div>
                                        </div>
                                    </div>
                                    <!-- end add new item collapse -->
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row d-flex">
                        <div class="col-12 grid-margin stretch-card">
                            <div class="container-fluid">
                                <div class="card px-4 mt-2">
                                    <div class="card-body">
                                        <h6 class="card-title">All Videos</h6>
                                        <p class="card-description">List of All Videos along with additional information.</p>
                                        <div class="table-responsive">
                                            <table id="videosDatatbl" class="table table-hover table-bordered table-striped table-row" style="width:100%">
                                                <thead>
                                                    <tr>
                                                        <!-- <th>Id</th>
                                                        <th>Name</th>
                                                        <th>Birthday</th>
                                                        <th>Grade</th>
                                                        <th>City</th>
                                                        <th>School</th>
                                                        <th>Contact</th>
                                                        <th>Requested Date</th>
                                                        <th>Option</th>
                                                        <th>Status</th> -->
                                                    </tr>
                                                </thead>
                                                <tbody>
                                    
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                    </div>
                    <!-- Video Details Modal -->
                    <div class="modal fade" id="videoDetailsModal" tabindex="-1" aria-labelledby="videoDetailsModalLabel" aria-hidden="true">
                        <div class="modal-dialog modal-xl">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="videoDetailsModalLabel">Videos for Grade: <span id="modalGradeLabel"></span></h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                </div>
                                <div class="modal-body">
                                    <table class="table table-striped table-bordered" id="gradeVideosTable">
                                        <thead>
                                            <tr>
                                            <th>No</th>
                                            <th>Video Id</th>
                                            <th>Video Name</th>
                                            <th>Main Title</th>
                                            <th>Subtitle</th>
                                            <th>Option</th>
                                            </tr>
                                        </thead>
                                        <tbody></tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Edit Video Modal -->
                    <div class="modal fade" id="editVideoModal" tabindex="-1" aria-labelledby="editVideoModalLabel" aria-hidden="true">
                        <div class="modal-dialog modal-lg">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="editVideoModalLabel">Edit Video</h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                </div>
                                <div class="modal-body">
                                    <form id="editVideoForm">
                                    <input type="hidden" id="editVideoId" name="videoId">

                                    <div class="row">
                                        <div class="input-group-sm col-md-6 mb-2">
                                        <label class="form-label">Main Title</label>
                                        <input type="text" id="editMainTitle" name="maintitle" class="form-control">
                                        </div>
                                        <div class="input-group-sm col-md-6 mb-2">
                                        <label class="form-label">Subtitle</label>
                                        <input type="text" id="editSubtitle" name="subtitle" class="form-control">
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="input-group-sm col-md-6 mb-2">
                                        <label class="form-label">Video Name</label>
                                        <input type="text" id="editVideoName" name="videoname" class="form-control">
                                        </div>
                                        <div class="input-group-sm col-md-6 mb-2">
                                        <label class="form-label">Video Link</label>
                                        <input type="text" id="editVideoLink" name="videolink" class="form-control">
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="input-group-sm col-md-6 mb-2">
                                            <label class="form-label">Target Grade</label>
                                            <select class="form-select form-select-sm" id="editTargetGrade" name="Targetgrade">
                                                <option value="6">6</option>
                                                <option value="7">7</option>
                                                <option value="8">8</option>
                                                <option value="9">9</option>
                                                <option value="10">10</option>
                                            </select>
                                        </div>
                                        <div class="input-group-sm col-md-6 mb-2">
                                        <label class="form-label">Files</label>
                                        <input type="file" id="editFiles" name="files" class="form-control">
                                        </div>
                                    </div>

                                    <div class="d-flex justify-content-end mt-3">
                                        <button type="submit" class="btn btn-success">Save Changes</button>
                                    </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>

                </main>
                <?php include 'includes/footer.php' ?>
            </div>
        </div>
        <?php include 'includes/js.php' ?>

        <Script>
            $(document).ready(function () {

                loadAllVideosData();

                let selectedMainTitleId = null; // Store the selected title ID
                let selectedTitleId = null; // Store the selected title ID

                $("#maintitle").autocomplete({
                    source: function (request, response) {
                        $.ajax({
                            url: "controller/gettitles.php",
                            dataType: "json",
                            data: { term: request.term },
                            success: function (data) {
                                console.log("Received Data:", data); // Debugging output

                                if (Array.isArray(data) && data.length > 0) {
                                    response(
                                        data.map(item => ({
                                            label: item.label, // Display in autocomplete dropdown
                                            value: item.value, // Set in input field
                                            id: item.id // Store the ID
                                        }))
                                    );
                                } else {
                                    console.log("No suggestions found.");
                                    response([]); // No results
                                }
                            },
                            error: function (xhr, status, error) {
                                console.log("AJAX Error:", error);
                            }
                        });
                    },
                    minLength: 1,
                    appendTo: "body",
                    select: function (event, ui) {
                        console.log("Selected Title:", ui.item.value, "ID:", ui.item.id);
                        $("#maintitle").val(ui.item.value); // Ensure input field updates
                        selectedMainTitleId = ui.item.id; // ✅ Store the selected title ID
                        console.log("Stored ID:", selectedMainTitleId); // Debugging
                        return false; // Prevent default behavior
                    }
                });

                $("#inputVideotittle").autocomplete({
                    source: function(request, response) {
                        $.ajax({
                            url: "controller/gettitles.php",
                            dataType: "json",
                            data: { term: request.term },
                            success: function(data) {
                                console.log("Received Data:", data); // Debugging output
                                
                                if (Array.isArray(data) && data.length > 0) {
                                    response(data.map(item => ({
                                        label: item.label, // Display in autocomplete list
                                        value: item.value, // Set in input field
                                        id: item.id // Store for later use
                                    })));
                                } else {
                                    console.log("No suggestions found.");
                                    response([]);
                                }
                            },
                            error: function(xhr, status, error) {
                                console.log("AJAX Error:", error);
                            }
                        });
                    },
                    minLength: 1,
                    appendTo: "body",
                    select: function(event, ui) {
                        console.log("Selected:", ui.item.value, "ID:", ui.item.id);
                        $("#inputVideotittle").val(ui.item.value);
                        selectedTitleId = ui.item.id;
                        console.log(ui.item.id); // Debug
                        return false;
                    }
                });



                $("#inputVideoStittle").autocomplete({
                    source: function(request, response) {
                        $.ajax({
                            url: "controller/getstitles.php",  // Your backend script
                            dataType: "json",
                            data: {
                                term: request.term,              // The search term entered by the user
                                titleId: selectedTitleId         // The selected title ID, to filter results
                            },
                            success: function(data) {
                                console.log("Received Data:", data); // Debugging output

                                if (Array.isArray(data) && data.length > 0) {
                                    response(data); // Return the filtered data
                                } else {
                                    console.log("No suggestions found.");
                                    response([]); // No results
                                }
                            },
                            error: function(xhr, status, error) {
                                console.error("AJAX Error:", status, error);
                                console.log("Response Text:", xhr.responseText); // Show server response
                            }
                        });
                    },
                    minLength: 1,
                    appendTo: "body", // Ensures autocomplete appears above modal
                    select: function(event, ui) {
                        console.log("Selected:", ui.item.value, "ID:", ui.item.id);
                        $("#inputVideoStittle").val(ui.item.value); // Ensure the input field updates
                        $("#inputVideoSId").val(ui.item.id); // Store the selected subtitle ID (if needed)
                        return false; // Prevent default behavior
                    }
                });





                $("#addtitlebtn").click(function () {
                    let titleName = $("#titleName").val().trim();
                    let targetGrade = $("#inputTargetgrade").val();

                    if (titleName === "") {
                        Swal.fire({
                            icon: "warning",
                            title: "Oops!",
                            text: "Please enter a title name.",
                            confirmButtonColor: "#3085d6",
                        });
                        return;
                    }

                    $.ajax({
                        url: "controller/addnewtitle.php", // PHP script to handle the request
                        type: "POST",
                        data: { titleName: titleName, targetGrade: targetGrade },
                        dataType: "json",
                        success: function (response) {
                            if (response.success) {
                                // Show SweetAlert success message
                                Swal.fire({
                                    icon: "success",
                                    title: "Success!",
                                    text: "Title has been successfully added.",
                                    showConfirmButton: false,
                                    timer: 2000, // Auto close after 2 seconds
                                });

                                // Clear input fields
                                $("#titleName").val("");
                                $("#inputTargetgrade").val("6");

                                // Close modal after 2 seconds
                                setTimeout(function () {
                                    $("#addnewtitlemodal").modal("hide");
                                    $("#successMessage").hide(); // Hide message after closing
                                }, 2000);
                            } else {
                                alert("Error: " + response.error);
                            }
                        },
                        error: function (xhr, status, error) {
                            console.error("AJAX Error:", status, error);
                        }
                    });
                });

                $("#addsubtitlebtn").click(function () {
                    let subtitle = $("#inputsubtitle").val().trim(); // Get subtitle text

                    if (!selectedMainTitleId) {
                        Swal.fire({
                            icon: "warning",
                            title: "Oops!",
                            text: "Please select a main title first.",
                            confirmButtonColor: "#3085d6",
                        });
                        return;
                    }

                    if (subtitle === "") {
                        Swal.fire({
                            icon: "warning",
                            title: "Oops!",
                            text: "Please enter a subtitle.",
                            confirmButtonColor: "#3085d6",
                        });
                        return;
                    }

                    $.ajax({
                        url: "controller/addnewstitle.php", // Your backend script
                        type: "POST",
                        data: {
                            videoTitleId: selectedMainTitleId, // Send the selected title ID
                            subtitle: subtitle
                        },
                        dataType: "json",
                        success: function (response) {
                            if (response.success) {
                                Swal.fire({
                                    icon: "success",
                                    title: "Success!",
                                    text: "Subtitle has been added successfully.",
                                    showConfirmButton: false,
                                    timer: 2000,
                                });

                                $("#maintitle").val("");  // Clear main title field
                                $("#inputsubtitle").val(""); // Clear subtitle field

                                selectedMainTitleId = null;
                            } else {
                                Swal.fire({
                                    icon: "error",
                                    title: "Error!",
                                    text: response.error,
                                    confirmButtonColor: "#d33",
                                });
                            }
                        },
                        error: function (xhr, status, error) {
                            console.error("AJAX Error:", status, error);
                            Swal.fire({
                                icon: "error",
                                title: "AJAX Error!",
                                text: "Something went wrong. Please try again.",
                                confirmButtonColor: "#d33",
                            });
                        }
                    });
                });

            });

            function loadAllVideosData() {
                $.ajax({
                    type: "POST",
                    url: "controller/getvideosdata.php",  // A new endpoint that fetches approved students
                    dataType: "json",
                    success: function (data) {
                        console.log(data); // Debug: Check the structure of the response

                        // Clear existing table rows
                        $("#videosDatatbl tbody").empty();

                        // Set table headers (if needed)
                        if ($("#videosDatatbl thead th").length === 0) {
                            var tableHeaders =
                                "<th>No</th>" +
                                "<th>Grade</th>" +
                                "<th>Videos Count</th>" +
                                "<th>Details</th>" +
                                "<th>Option</th>";
                            $("#videosDatatbl thead tr").html(tableHeaders);
                        }

                        // Iterate through the received data and append rows
                        $.each(data, function (index, row) {
                            var newRow =
                                "<tr>" +
                                "<td>" + row.no + "</td>" +
                                "<td>" + row.grade + "</td>" +
                                "<td>" + row.count + "</td>" +
                                "<td><button class='btn btn-sm btn-primary view-details-btn' data-grade='" + row.grade + "'>View Details</button></td>" +
                                "<td><button class='btn btn-sm btn-danger delete-grade-btn' data-grade='" + row.grade + "'>Delete</button></td>" +
                                "</tr>";

                            $("#videosDatatbl tbody").append(newRow);
                        });

                        // Initialize DataTable only if it is not already initialized
                        if (!$.fn.dataTable.isDataTable('#videosDatatbl')) {
                            $('#videosDatatbl').DataTable({
                                paging: true,
                                scrollY: '300px',
                                scrollX: true,
                                scrollCollapse: true,
                            });
                        } else {
                            // If DataTable is already initialized, just reload the table data
                            $('#videosDatatbl').DataTable().clear().rows.add($("#videosDatatbl tbody tr")).draw();
                        }
                    },
                    error: function (xhr, status, error) {
                        console.error("Error loading data: ", error);
                    }
                });
            }

            $(document).on('click', '.view-details-btn', function () {
                var grade = $(this).data('grade');

                // Set the modal title
                $("#modalGradeLabel").text(grade);

                // Clear old table data
                $("#gradeVideosTable tbody").empty();

                // Fetch videos by grade
                $.ajax({
                    url: 'controller/getvideosbygrade.php', // Create this next
                    type: 'GET',
                    data: { grade: grade },
                    dataType: 'json',
                    success: function (videos) {
                        if (Array.isArray(videos)) {
                            $.each(videos, function (index, video) {
                                var row = "<tr>" +
                                    "<td>" + (index + 1) + "</td>" +
                                    "<td>" + video.sttwoId + "</td>" +
                                    "<td>" + video.sttwoName + "</td>" +
                                    "<td>" + video.maintitle + "</td>" +
                                    "<td>" + video.subtitle + "</td>" +
                                    "<td>" +
                                        "<button class='btn btn-sm btn-warning edit-video-btn me-2' data-id='" + video.sttwoId + "'>Edit</button>" +
                                        "<button class='btn btn-sm btn-danger delete-video-btn' data-id='" + video.sttwoId + "'>Delete</button>" +
                                    "</td>" +
                                    "</tr>";
                                $("#gradeVideosTable tbody").append(row);
                            });
                        } else {
                            $("#gradeVideosTable tbody").html("<tr><td colspan='4'>No videos found.</td></tr>");
                        }

                        // Show the modal
                        $('#videoDetailsModal').modal('show');
                    },
                    error: function () {
                        alert('Failed to load video details.');
                    }
                });
            });

            $(document).on('click', '.delete-video-btn', function () {
                var button = $(this);
                var videoId = button.data('id');

                if (confirm("Are you sure you want to delete this video?")) {
                    $.ajax({
                        url: 'controller/deletevideo.php',
                        type: 'POST',
                        data: { id: videoId },
                        success: function (response) {
                            // Optionally check response success
                            button.closest('tr').remove(); // Remove row from table

                             // Reload the main videos summary table
                            loadAllVideosData();
                        },
                        error: function () {
                            alert("Failed to delete video.");
                        }
                    });
                }
            });

            $("#editMainTitle").autocomplete({
                    source: function (request, response) {
                        $.ajax({
                            url: "controller/gettitles.php",
                            dataType: "json",
                            data: { term: request.term },
                            success: function (data) {
                                console.log("Received Data:", data); // Debugging output

                                if (Array.isArray(data) && data.length > 0) {
                                    response(
                                        data.map(item => ({
                                            label: item.label, // Display in autocomplete dropdown
                                            value: item.value, // Set in input field
                                            id: item.id // Store the ID
                                        }))
                                    );
                                } else {
                                    console.log("No suggestions found.");
                                    response([]); // No results
                                }
                            },
                            error: function (xhr, status, error) {
                                console.log("AJAX Error:", error);
                            }
                        });
                    },
                    minLength: 1,
                    appendTo: "body",
                    select: function (event, ui) {
                        console.log("Selected Title:", ui.item.value, "ID:", ui.item.id);
                        $("#editMainTitle").val(ui.item.value); // Ensure input field updates
                        selectedTitleId = ui.item.id; // ✅ Store the selected title ID
                        console.log("Stored ID:", selectedTitleId); // Debugging
                        return false; // Prevent default behavior
                    }
                });
                $("#editSubtitle").autocomplete({
                    source: function(request, response) {
                        $.ajax({
                            url: "controller/getstitles.php",  // Your backend script
                            dataType: "json",
                            data: {
                                term: request.term,              // The search term entered by the user
                                titleId: selectedTitleId         // The selected title ID, to filter results
                            },
                            success: function(data) {
                                console.log("Received Data:", data); // Debugging output

                                if (Array.isArray(data) && data.length > 0) {
                                    response(data); // Return the filtered data
                                } else {
                                    console.log("No suggestions found.");
                                    response([]); // No results
                                }
                            },
                            error: function(xhr, status, error) {
                                console.error("AJAX Error:", status, error);
                                console.log("Response Text:", xhr.responseText); // Show server response
                            }
                        });
                    },
                    minLength: 1,
                    appendTo: "body", // Ensures autocomplete appears above modal
                    select: function(event, ui) {
                        console.log("Selected:", ui.item.value, "ID:", ui.item.id);
                        $("#editSubtitle").val(ui.item.value); // Ensure the input field updates
                        // $("#inputVideoSId").val(ui.item.id); // Store the selected subtitle ID (if needed)
                        return false; // Prevent default behavior
                    }
                });
            // Open Edit Modal & Load Data
            $(document).on('click', '.edit-video-btn', function () {
                // var videoId = $(this).data('id');
                var videoId = $(this).data('id');
                console.log(videoId);

                $.ajax({
                    url: 'controller/getvideobyid.php', // 
                    type: 'GET',
                    data: { id: videoId },
                    dataType: 'json',
                    success: function (row) {
                        // Fill modal fields
                        if(row){
                            $("#editVideoId").val(row.sttwoId);
                            $("#editMainTitle").val(row.maintitle);
                            $("#editSubtitle").val(row.subtitle);
                            $("#editVideoName").val(row.sttwoName);
                            $("#editVideoLink").val(row.videourl);
                            $("#editTargetGrade").val(row.videograde);

                            // Show modal
                            $("#editVideoModal").modal('show');
                            console.log(row);
                        }
                        else {
                            alert("Failed to fetch video details.");
                        }
                    }
                });
            });

            // // Save Edited Video
            // $("#editVideoForm").submit(function (e) {
            //     e.preventDefault();

            //     $.ajax({
            //         url: 'controller/updatevideo.php',
            //         type: 'POST',
            //         data: $(this).serialize(),
            //         success: function (response) {
            //             $("#editVideoModal").modal('hide');
            //             Swal.fire("Updated!", "Video updated successfully.", "success");

            //             // Refresh videos
            //             loadAllVideosData();
            //             $('#videoDetailsModal').modal('hide');
            //         },
            //         error: function () {
            //             Swal.fire("Error!", "Failed to update video.", "error");
            //         }
            //     });
            // });

            // Handle Update Video form submission
            $(document).ready(function () {
    $("#editVideoForm").on("submit", function (e) {
        e.preventDefault(); // stop normal form submit

        var formData = new FormData(this); // get all form fields (including file)
        console.log('form Data:-'+formData);
        $.ajax({
    url: "controller/updatevideo.php",
    type: "POST",
    data: formData,
    processData: false,
    contentType: false,
    dataType: "json", // 👈 jQuery parses automatically
    success: function (res) {
        console.log("Server Response:", res);

        if (res.status === "success") {
            alert("✅ Video updated successfully!");
            $("#editVideoModal").modal("hide");
        } else {
            alert("❌ Error: " + res.message);
        }
    },
    error: function (xhr, status, error) {
        console.error("AJAX Error:", status, error);
        console.log("Raw Response:", xhr.responseText); // see exact server output
        alert("❌ AJAX Request failed. Check console.");
    }
});
    });
});








        </Script>

    </body>
</html>
